import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:sizer/sizer.dart';

class RequestErrorScreen extends StatelessWidget {
  final Function onBack;
  final String url;
  final String statusCode;
  final String description;

  const RequestErrorScreen(
      {Key? key,
      required this.onBack,
      required this.url,
      required this.statusCode,
      required this.description})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        toolbarHeight: 60.0,
        leading: Material(
          type: MaterialType.transparency,
          child: InkWell(
            onTap: () {
              Navigator.pop(context);
              onBack();
            },
            child: Container(
              margin: const EdgeInsets.all(10.0),
              decoration: BoxDecoration(
                color: Color(0xffDFDFDF),
                shape: BoxShape.circle,
              ),
              child: const Center(
                child: Icon(
                  Icons.arrow_back_ios_outlined,
                  size: 20.0,
                  color: Colors.black,
                ),
              ),
            ),
          ),
        ),
      ),
      backgroundColor: Color(0xFFe5e5e5),
      body: SingleChildScrollView(
        physics: const AlwaysScrollableScrollPhysics(),
        child: Container(
          height: 100.0.h,
          width: 100.0.w,
          child: Center(
            child: Container(
              height: 40.0.h,
              padding: EdgeInsets.symmetric(horizontal: 5.0.w),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  const Icon(Icons.error,
                      color: AppColors.color333333, size: 60.0),
                  Text(
                    statusCode,
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff282828),
                        fontSize: 24.0,
                        fontWeight: FontWeight.w700),
                  ),
                  const SizedBox(height: 12.0),
                  Text(
                    url,
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff747474),
                        fontSize: 15.0,
                        fontWeight: FontWeight.w400),
                    maxLines: 4,
                    overflow: TextOverflow.ellipsis,
                  ),
                  Text(
                    description,
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff747474),
                        fontSize: 15.0,
                        fontWeight: FontWeight.w400),
                    maxLines: 4,
                    overflow: TextOverflow.ellipsis,
                  ),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}
