import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';

import 'custom_loading_indicator.dart';

class PageLoading extends StatelessWidget {
  final Color indicatorColor;
  final Color? backgroundColor;

  const PageLoading({
    Key? key,
    this.indicatorColor = AppColors.selectedColor,
    this.backgroundColor,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: backgroundColor ?? Colors.transparent,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          const CustomLoadingIndicator(
              color: AppColors.unSelectedColor, strokeWidth: 3.0),
        ],
      ),
    );
  }
}
