import 'package:flutter/material.dart';
import 'package:road24_mobile/data/http/ApiException.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/my_app.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:sizer/sizer.dart';

class NoConnectionScreen extends StatelessWidget {
  final Function onTap;
  final String? message;

  const NoConnectionScreen({Key? key, required this.onTap, this.message})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    if (message != null) ApiException.errorMessage.value = message;
    return Scaffold(
      backgroundColor: Color(0xFFe5e5e5),
      body: SingleChildScrollView(
        physics: const AlwaysScrollableScrollPhysics(),
        child: Container(
          height: 100.0.h,
          width: 100.0.w,
          child: Center(
            child: Container(
              height: 40.0.h,
              padding: EdgeInsets.symmetric(horizontal: 5.0.w),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const Icon(
                    Icons.warning_amber_rounded,
                    color: AppColors.color333333,
                    size: 60.0,
                  ),
                  Text(
                    S.of(context).no_network,
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff282828),
                        fontSize: 24.0,
                        fontWeight: FontWeight.w700),
                  ),
                  const SizedBox(height: 12.0),
                  Text(
                    "${S.of(context).check_connection}\n${ApiException.errorMessage.value ?? ''}",
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff747474),
                        fontSize: 15.0,
                        fontWeight: FontWeight.w400),
                    maxLines: 4,
                    overflow: TextOverflow.ellipsis,
                  ),
                  // SizedBox(height: 20,),
                  Padding(
                    padding: EdgeInsets.symmetric(vertical: 1.0.h),
                    child: Container(
                      height: 8.0.h,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(12.0),
                        color: Color(0xFFdcdcdc),
                        boxShadow: [
                          BoxShadow(
                            color: Color(0xFFdcdcdc).withOpacity(0.1),
                            offset: Offset(5.0, 10.0),
                            blurRadius: 7.0.sp,
                          ),
                        ],
                      ),
                      child: InkWell(
                        borderRadius: BorderRadius.circular(12.0),
                        onTap: () {
                          MyApp.hasInternet.value = true;
                          ApiException.errorMessage.value = "";
                          onTap();
                        },
                        child: Container(
                          padding: EdgeInsets.all(2.0.w),
                          child: Center(
                            child: Text(
                              S.of(context).refresh,
                              style: AppStyle.textStyle().copyWith(
                                  color: Color(0xff333333),
                                  fontWeight: FontWeight.w600,
                                  fontSize: 16.0),
                            ),
                          ),
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}
