import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';

class BetweenListItem extends StatelessWidget {
  final String title;
  final String trailingText;
  final bool isTrailingIconNeeded;
  final String? svgPath;
  final String? subText;

  const BetweenListItem(
      {Key? key,
      required this.title,
      required this.trailingText,
      this.isTrailingIconNeeded = false,
      this.svgPath,
      this.subText})
      : super(key: key);

  static final trailingTextStyle = const TextStyle(
      fontSize: 16, color: Color(0xff282828), fontWeight: FontWeight.w500);

  static final titleStyle = const TextStyle(
      fontSize: 17, color: Color(0xff747474), fontWeight: FontWeight.w600);

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 8.0),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Flexible(flex: 6, child: Text(title, style: titleStyle)),
          Flexible(child: const SizedBox(), flex: 1),
          Flexible(
              flex: 8,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.end,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.end,
                    children: [
                      if (svgPath != null)
                        SvgPicture.asset(
                          "assets/svg/$svgPath.svg",
                          color: Colors.black,
                        ),
                      if (svgPath != null)
                        const SizedBox(
                          width: 4,
                        ),
                      Flexible(
                        child: Text(
                          trailingText,
                          style: trailingTextStyle,
                          textAlign: TextAlign.end,
                          maxLines: 3,
                        ),
                      ),
                    ],
                  ),
                  if (subText != null)
                    Text(
                      "$subText",
                      style: TextStyle(
                          fontSize: 13,
                          color: Color(0xff747474),
                          fontWeight: FontWeight.w500),
                      textAlign: TextAlign.end,
                      maxLines: 2,
                    ),
                ],
              )),
        ],
      ),
    );
  }
}
