import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:road24_mobile/data/response/NotificationsResponse.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class NotificationItemNew extends StatefulWidget {
  final Results notification;
  final String? date;
  final String svgIconName;
  const NotificationItemNew(
      {Key? key,
      required this.notification,
      required this.svgIconName,
      this.date})
      : super(key: key);

  @override
  _NotificationItemState createState() => _NotificationItemState();
}

class _NotificationItemState extends State<NotificationItemNew> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 12),
          child: Row(
            mainAxisSize: MainAxisSize.max,
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Container(
                width: 40,
                height: 40,
                decoration: BoxDecoration(
                    color: Color(0xffdfdfdf),
                    borderRadius: BorderRadius.circular(50)),
                // margin: EdgeInsets.symmetric(horizontal: 10),
                padding: const EdgeInsets.all(8),
                child: SvgPicture.asset(
                  "assets/svg/${widget.svgIconName}.svg",
                  height: 20.0,
                  width: 20.0,
                  // color: Color(0xff747474),
                ),
              ),
              const SizedBox(
                width: 12,
              ),
              Expanded(
                child: Column(
                  mainAxisSize: MainAxisSize.max,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        if (!widget.notification.isRead)
                          Row(
                            children: [
                              Container(
                                margin:
                                    const EdgeInsets.symmetric(vertical: 4.0),
                                height: 5.0,
                                width: 5.0,
                                decoration: const BoxDecoration(
                                    color: Color(0xFFF51A51),
                                    shape: BoxShape.circle),
                              ),
                              const SizedBox(width: 3.0),
                            ],
                          ),
                        Flexible(
                          child: Text(
                            (widget.notification.notificationContent!.content !=
                                    null)
                                ? widget.notification.notificationContent!
                                    .content!.title
                                : '',
                            maxLines: 2,
                            textAlign: TextAlign.start,
                            overflow: TextOverflow.ellipsis,
                            style: AppStyle.textStyle().copyWith(
                                color: Color(0xff1e1e1e),
                                fontSize: 16,
                                fontWeight: FontWeight.w700,
                                fontFamily: "SF Pro"),
                          ),
                        ),
                      ],
                    ),
                    const SizedBox(height: 4.0),
                    Text(
                      (widget.notification.notificationContent!.content != null)
                          ? widget
                              .notification.notificationContent!.content!.body
                          : '',
                      maxLines: 2,
                      textAlign: TextAlign.start,
                      overflow: TextOverflow.ellipsis,
                      style: AppStyle.textStyle().copyWith(
                          color: Color(0xff888888),
                          fontSize: 14,
                          fontWeight: FontWeight.w400,
                          fontFamily: "SF Pro"),
                    ),
                    if (widget.date != null)
                      Padding(
                        padding: const EdgeInsets.only(top: 8.0),
                        child: Text(
                          widget.date!,
                          style: AppStyle.textStyle().copyWith(
                              color: Color(0xff959595),
                              fontSize: 12,
                              fontWeight: FontWeight.w400,
                              fontFamily: "SF Pro"),
                        ),
                      ),
                  ],
                ),
              ),
            ],
          ),
        ),
        Container(
          height: 1.0,
          margin: const EdgeInsets.symmetric(horizontal: 16),
          color: AppColors.colorcacaca,
        ),
      ],
    );
  }
}
