import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class ManualItem extends StatelessWidget {
  final Function()? onTap;
  final String svgIconPath;
  final String title;

  const ManualItem(
      {Key? key, this.onTap, required this.svgIconPath, required this.title})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        height: 148.0,
        width: 164.0,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(16.0),
          color: Colors.white,
        ),
        padding: const EdgeInsets.symmetric(horizontal: 15.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Expanded(
              flex: 3,
              child: Align(
                alignment: Alignment.bottomCenter,
                child: Container(
                  height: 56.0,
                  width: 56.0,
                  padding: const EdgeInsets.all(12.0),
                  margin: const EdgeInsets.symmetric(vertical: 10.0),
                  decoration: BoxDecoration(
                    shape: BoxShape.circle,
                    color: AppColors.colore8e8e8,
                  ),
                  child: Center(child: SvgPicture.asset(svgIconPath)),
                ),
              ),
            ),
            Expanded(
              flex: 2,
              child: Text(
                title,
                style: AppStyle.textStyle().copyWith(
                  color: Color(0xff747474),
                  fontSize: 14.0,
                  fontWeight: FontWeight.w500,
                ),
                maxLines: 2,
                textAlign: TextAlign.center,
              ),
            )
          ],
        ),
      ),
    );
  }
}
