import 'package:animate_do/animate_do.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/InspectionManualResponse.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/manual/parts/inspection/InspectionPlaces/inspection_widgets.dart';

class ListOfPlacesItem extends StatelessWidget {
  final Address placeItem;

  const ListOfPlacesItem({
    Key? key,
    required this.placeItem,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return FadeInRight(
      duration: const Duration(milliseconds: 200),
      child: Container(
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(16.0),
        ),
        padding: const EdgeInsets.symmetric(horizontal: 16.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            const SizedBox(height: 16.0),
            Text(
              placeItem.name,
              style: AppStyle.textStyle().copyWith(
                color: Color(0xff282828),
                fontSize: 20.0,
                fontWeight: FontWeight.w700,
              ),
            ),
            const SizedBox(height: 1.0),
            Text(
              placeItem.type,
              style: AppStyle.textStyle().copyWith(
                color: Color(0xff282828),
                fontSize: 14.0,
                fontWeight: FontWeight.w400,
              ),
              maxLines: 2,
            ),
            const SizedBox(height: 16.0),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  width: 40.0,
                  height: 40.0,
                  decoration: const BoxDecoration(
                    color: AppColors.colore8e8e8,
                    shape: BoxShape.circle,
                  ),
                  child: Center(
                    child: SvgPicture.asset("assets/svg/location.svg"),
                  ),
                ),
                const SizedBox(width: 9.0),
                Flexible(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        '${S.of(context).address}:',
                        style: AppStyle.textStyle().copyWith(
                          color: Color(0xff282828),
                          fontSize: 14.0,
                          fontWeight: FontWeight.w700,
                        ),
                      ),
                      Text(
                        placeItem.address ?? "",
                        style: AppStyle.textStyle().copyWith(
                          color: Color(0xffF858585),
                          fontSize: 14.0,
                          fontWeight: FontWeight.w500,
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
            const SizedBox(height: 8.0),
            ServiceTypes(
              legal: placeItem.legalEntityService,
              individual: placeItem.individualService,
              texpassport: placeItem.texpasportService,
              prava: placeItem.licenseService,
            ),
            const SizedBox(height: 20.0),
          ],
        ),
      ),
    );
  }
}
