import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class InfoButtonWidget extends StatelessWidget {
  final Function() onClicked;
  final String svgName;
  final String title;
  final Color? backgroundColor;

  const InfoButtonWidget(
      {Key? key,
      required this.onClicked,
      required this.svgName,
      required this.title,
      this.backgroundColor})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onClicked,
      child: Container(
        padding: const EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: backgroundColor ?? Colors.white,
          borderRadius: BorderRadius.circular(16),
        ),
        child: Row(
          children: [
            Container(
              padding: const EdgeInsets.all(8),
              decoration: const BoxDecoration(
                color: AppColors.appPrimaryColor,
                shape: BoxShape.circle,
              ),
              child: SvgPicture.asset(
                "assets/svg/$svgName.svg",
                height: 20,
              ),
            ),
            const SizedBox(width: 12),
            Text(
              title,
              style: AppStyle.textStyle().copyWith(
                color: Color(0xff282828),
                fontSize: 16,
                fontWeight: FontWeight.w500,
              ),
            ),
            const Spacer(),
            const Icon(
              Icons.chevron_right,
              color: Color(0xFF858585),
            ),
          ],
        ),
      ),
    );
  }
}
