import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:road24_mobile/data/response/FinesResponse.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/utils/extensions.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:sizer/sizer.dart';
import 'package:road24_mobile/utils/frequent_widgets.dart';

class FinesListItem extends StatefulWidget {
  final Function()? onTap;
  final Results result;
  final bool isHistory;
  final bool isRoad;

  const FinesListItem(
      {Key? key,
      this.onTap,
      required this.result,
      this.isHistory = false,
      this.isRoad = false})
      : super(key: key);

  @override
  _FinesListItemState createState() => _FinesListItemState();
}

class _FinesListItemState extends State<FinesListItem> {
  String humanizeCost(String sum) {
    if (sum.endsWith('.0')) {
      sum = sum + '0';
    }
    List<String> sumBuffer = sum.split('.');
    String refactoredSumFormat =
        FrequentWidgets.intComma(int.parse(sumBuffer[0])).replaceAll(',', ' ') +
            '.' +
            sumBuffer[1].toString();
    refactoredSumFormat = refactoredSumFormat.replaceAll(".00", "");
    return refactoredSumFormat;
  }

  @override
  Widget build(BuildContext context) {
    // print("pAmount");
    // print(widget.result.pAmount);

    return InkWell(
      onTap: widget.onTap,
      highlightColor: Colors.transparent,
      splashColor: Colors.transparent,
      child: Container(
        padding: const EdgeInsets.symmetric(vertical: 5.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            // Text(widget.result.id.toString()),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  // "${widget.result.id}",
                  "${widget.result.pSeryNumber}",
                  style: AppStyle.textStyle().copyWith(
                    color: Color(0xff333333),
                    fontSize: 17.0,
                    fontWeight: FontWeight.w600,
                  ),
                  textAlign: TextAlign.left,
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis,
                ),
                Text(
                  DateTime.parse(widget.result.pDate!).dateToStr(),
                  // FrequentWidgets.dateTimeToLocal(widget.result.pDate!),
                  style: AppStyle.textStyle().copyWith(
                    color: Color(0xff747474),
                    fontSize: 14.0,
                    fontWeight: FontWeight.w400,
                  ),
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis,
                ),
              ],
            ),
            const SizedBox(height: 5.0),
            Row(
              children: [
                Expanded(
                  child: Column(
                    children: [
                      // SizedBox(height: 2.0),
                      Text(
                        // "${widget.result.id}",
                        "${widget.result.pViolation!.desc}",
                        style: AppStyle.textStyle().copyWith(
                          color: Color(0xff333333),
                          fontSize: 17.0,
                          fontWeight: FontWeight.w500,
                        ),
                        textAlign: TextAlign.left,
                        maxLines: 2,
                        overflow: TextOverflow.ellipsis,
                      ),
                      const SizedBox(height: 5.0),
                      Text(
                        "${humanizeCost(widget.result.pAmount!)} ${S.of(context).uzs.toLowerCase()}",
                        style: AppStyle.textStyle().copyWith(
                          color: Color(0xffF51A51),
                          fontSize: 18.0,
                          fontWeight: FontWeight.w600,
                        ),
                        textAlign: TextAlign.center,
                        maxLines: 1,
                        overflow: TextOverflow.ellipsis,
                      ),
                      const SizedBox(height: 4.0),
                      Row(
                        children: [
                          if (!widget.isHistory)
                            SvgPicture.asset(
                              'assets/svg/location.svg',
                            ),
                          if (!widget.isHistory) SizedBox(width: 2.0.w),
                          if (widget.result.pPlace != null)
                            Expanded(
                              child: Text(
                                "${widget.result.pPlace}",
                                style: AppStyle.textStyle().copyWith(
                                  color: Color(0xff747474),
                                  fontSize: 14.0,
                                  fontWeight: FontWeight.w400,
                                ),
                                maxLines: 2,
                                overflow: TextOverflow.ellipsis,
                              ),
                            ),
                        ],
                      ),
                      if (widget.isHistory && !widget.isRoad)
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Padding(
                              padding:
                                  const EdgeInsets.only(right: 8.0, top: 8),
                              child: Text(
                                widget.result.remain! == "0.00"
                                    ? S.of(context).paid
                                    : S.of(context).partially_paid,
                                style: AppStyle.textStyle().copyWith(
                                  color: Color(0xffF51A51),
                                  fontSize: 14.0,
                                  fontWeight: FontWeight.w600,
                                ),
                              ),
                            ),
                            if (widget.isHistory &&
                                widget.result.checkId != null)
                              Padding(
                                padding: const EdgeInsets.only(top: 9.0),
                                child: SvgPicture.asset(
                                  "assets/svg/road24_icon.svg",
                                  width: 70,
                                ),
                              ),
                          ],
                        )
                    ],
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                  ),
                ),
                const Icon(
                  Icons.chevron_right_rounded,
                  color: Color(0xff747474),
                ),
              ],
            ),
            const SizedBox(height: 10.0),
            const Divider(color: Color(0xffCACACA), thickness: 1.0),
          ],
        ),
      ),
    );
  }
}
