import 'dart:ui';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:road24_mobile/data/response/GetCardResponse.dart';
import 'package:road24_mobile/model/blocs/card/card_bloc.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/settings/card/add/sms_verification_for_card_page.dart';
import 'package:road24_mobile/view/settings/card/cards_page.dart';
import 'package:road24_mobile/view/widgets/custom_dialog.dart';

class CardItem extends StatelessWidget {
  final CardResults card;
  final int gradientId;

  const CardItem({Key? key, required this.card, required this.gradientId})
      : super(key: key);

  _deleteCard(int id) async {
    CardsPage.loading.value = true;

    print("deleting $id");
    CardsPage.cardBloc.add(
      DeleteCardEvent(id),
    );
  }

  logoAsset(String bankPath) {
    return "assets/banks_logos/$bankPath.png";
  }

  bankLogoImage(String number) {
    String logo = "";
    switch (number) {
      case "860002":
        logo = logoAsset("bank-nbu");
        break;
      case "860003":
        logo = logoAsset("bank-o-zsanoatqurilishbank");
        break;
      case "860004":
        logo = logoAsset("bank-agrobank");
        break;
      case "860005":
        logo = logoAsset("bank-mikrokreditbank");
        break;
      case "860006":
        logo = logoAsset("bank-xalq-bank");
        break;
      case "860008":
        logo = logoAsset("bank-savdogar-bank");
        break;
      case "860009":
        logo = logoAsset("bank-qishloq-qurilish-bank");
        break;

      case "860011":
        logo = logoAsset("bank-turon-bank");
        break;
      case "860012":
        logo = logoAsset("bank-hamkor-bank");
        break;
      case "860013":
        logo = logoAsset("bank-asaka-bank");
        break;
      case "860014":
        logo = logoAsset("bank-ipak-yuli-bank");
        break;
      case "860020":
        logo = logoAsset("bank-ziraat-bank");
        break;

      case "860030":
        logo = logoAsset("bank-trastbank");
        break;
      case "860031":
        logo = logoAsset("bank-aloqabank");
        break;
      case "860033":
        logo = logoAsset("bank-ipoteka-bank");
        break;
      case "860034":
        logo = logoAsset("bank-o-zkdb-bank");
        break;
      case "860038":
        logo = logoAsset("bank-turkistonbank");
        break;
      case "860048":
        logo = logoAsset("bank-universalbank");
        break;
      case "860049":
        logo = logoAsset("bank-kapital-bank");
        break;
      case "860050":
        logo = logoAsset("bank-ravnaq");
        break;
      case "860051":
        logo = logoAsset("bank-davr-bank");
        break;
      case "860053":
        logo = logoAsset("bank-infin-bank");
        break;
      case "860055":
        logo = logoAsset("bank-asia-alliance-bank");
        break;

      case "860056":
        logo = logoAsset("bank-hi-tech-bank");
        break;

      case "860057":
        logo = logoAsset("bank-orient-finans-bank");
        break;

      case "860058":
        logo = logoAsset("bank-madad-invest-bank");
        break;

      case "860059":
        logo = logoAsset("bank-o-zagroeksportbank");
        break;
      case "860060":
        logo = logoAsset("bank-poytaxt-bank");
        break;
      case "9860":
        logo = logoAsset("humo");
        break;
    }
    if (logo.isNotEmpty)
      return Image.asset(
        logo,
        width: 80,
        height: 50,
      );
    return const SizedBox();
  }

  cardGradient() {
    return LinearGradient(
        colors: gradients[gradientId],
        begin: Alignment.bottomLeft,
        end: Alignment.topRight);
  }

  static List<List<Color>> gradients = [
    [
      Color(0xFF2f4759),
      Color(0xFF479fac),
    ],
    [
      Color(0xFF01adc2),
      Color(0xFF85e6f6),
    ],
    [
      Color(0xFFffac06),
      Color(0xFFfedd00),
    ],
    [
      Color(0xFF9cbee1),
      Color(0xFFbbe7f8),
    ],
    [
      Color(0xFF217ace),
      Color(0xFF1fbbf6),
    ],
    [
      Color(0xFF7160e1),
      Color(0xFFd562c3),
    ],
    [
      Color(0xFF123075),
      Color(0xFF4490ef),
    ],
    [
      Color(0xFF3bd5a6),
      Color(0xFFb0ecb0),
    ],
  ];

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: () {
        if (!card.isVerified)
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => SmsVerificationForCardPage(
                cardId: card.id,
                isResendSmsCode: true,
              ),
            ),
          );
      },
      child: Container(
        height: 179,
        width: 290,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(13.0),
          gradient: cardGradient(),
        ),
        child: Stack(
          children: [
            Center(
              child: Padding(
                padding: const EdgeInsets.symmetric(
                    vertical: 20.0, horizontal: 20.0),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Expanded(
                      child: card.number.startsWith("9860")
                          ? bankLogoImage(card.number.substring(0, 4))
                          : bankLogoImage(card.number.substring(0, 6)),
                    ),
                    const SizedBox(height: 10),
                    if (!card.isVerified)
                      Container(
                        color: Colors.red,
                        alignment: Alignment.center,
                        padding: const EdgeInsets.symmetric(vertical: 4),
                        child: Text(
                          S.of(context).notValidatedCard,
                          style: AppStyle.textStyle().copyWith(
                              color: Colors.white,
                              fontWeight: FontWeight.w600,
                              fontSize: 13.0),
                          overflow: TextOverflow.ellipsis,
                          maxLines: 2,
                          textAlign: TextAlign.center,
                        ),
                      ),
                    Expanded(
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              card.number.substring(0, 4),
                              style: AppStyle.textStyle().copyWith(
                                  color: Colors.white,
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18.0),
                            ),
                          ),
                          Expanded(
                            child: Text(
                              "${card.number.substring(4, 6)}••",
                              style: AppStyle.textStyle().copyWith(
                                  color: Colors.white,
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18.0),
                            ),
                          ),
                          Expanded(
                            child: Text(
                              "••••",
                              style: AppStyle.textStyle().copyWith(
                                  color: Colors.white,
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18.0),
                            ),
                          ),
                          Expanded(
                            child: Text(
                              "${card.number.substring(12)}",
                              style: AppStyle.textStyle().copyWith(
                                  color: Colors.white,
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18.0),
                              overflow: TextOverflow.ellipsis,
                              maxLines: 1,
                              textAlign: TextAlign.center,
                            ),
                          ),
                        ],
                      ),
                    ),
                    Row(
                      children: [
                        Expanded(
                          child: Text(
                            "${S.of(context).name_of_card}",
                            style: AppStyle.textStyle().copyWith(
                              fontWeight: FontWeight.normal,
                              fontSize: 10.0,
                              color: Colors.white.withOpacity(0.5),
                            ),
                            overflow: TextOverflow.ellipsis,
                            maxLines: 1,
                            textAlign: TextAlign.start,
                          ),
                        ),
                        Expanded(
                          child: Text(
                            "${S.of(context).validity}",
                            style: AppStyle.textStyle().copyWith(
                              fontWeight: FontWeight.normal,
                              fontSize: 10.0,
                              color: Colors.white.withOpacity(0.5),
                            ),
                            overflow: TextOverflow.ellipsis,
                            maxLines: 1,
                            textAlign: TextAlign.end,
                          ),
                        ),
                      ],
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Text(
                          "${card.fullName}",
                          style: AppStyle.textStyle().copyWith(
                              color: Colors.white,
                              fontWeight: FontWeight.normal,
                              fontSize: 13.0),
                          overflow: TextOverflow.ellipsis,
                          maxLines: 1,
                          textAlign: TextAlign.start,
                        ),
                        Text(
                          "${card.expire.substring(0, 2)}/${card.expire.substring(2, 4)}",
                          style: AppStyle.textStyle().copyWith(
                              color: Colors.white,
                              fontWeight: FontWeight.normal,
                              fontSize: 13.0),
                          overflow: TextOverflow.ellipsis,
                          maxLines: 1,
                          textAlign: TextAlign.end,
                        ),
                      ],
                    )
                  ],
                ),
              ),
            ),
            Align(
              alignment: Alignment.topRight,
              child: Padding(
                padding: const EdgeInsets.symmetric(vertical: 10.0),
                child: IconButton(
                  onPressed: () {
                    CustomDialog(
                      title: S.of(context).delete,
                      content: S.of(context).delete_card_content,
                      onNoTap: () {
                        Navigator.pop(context);
                      },
                      onYesTap: () async {
                        await _deleteCard(card.id);
                        Navigator.pop(context);
                      },
                    ).showAlertDialog(context);
                  },
                  icon: const Icon(
                    Icons.remove_circle_outline_outlined,
                    color: Colors.red,
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
