import 'package:carousel_slider/carousel_slider.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:road24_mobile/model/blocs/card/card_bloc.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/view/mycar/my_car_page.dart';
import 'package:road24_mobile/view/widgets/custom_button.dart';
import 'package:sizer/sizer.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/settings/card/cards_page.dart';
import 'package:road24_mobile/view/widgets/items/card_item.dart';

class CardBottomSheetItem extends StatefulWidget {
  final Function() onAddCard;
  final Function()? onPay;
  final String dateTimeToShow;
  final String fineNumberToShow;
  static int currentCard = 0;
  static bool fromFineDetailPage = false;

  const CardBottomSheetItem(
      {Key? key,
      required this.onAddCard,
      required this.onPay,
      required this.dateTimeToShow,
      required this.fineNumberToShow})
      : super(key: key);

  @override
  _CardBottomSheetItemState createState() => _CardBottomSheetItemState();
}

class _CardBottomSheetItemState extends State<CardBottomSheetItem> {
  @override
  void initState() {
    CardBottomSheetItem.fromFineDetailPage = true;
    super.initState();
  }

  @override
  void dispose() {
    CardBottomSheetItem.fromFineDetailPage = false;
    CardBottomSheetItem.currentCard = 0;
    super.dispose();
  }

  _loadData() async {
    CardsPage.cardBloc.add(GetCardsEvent());
  }

  @override
  Widget build(BuildContext context) {
    print(MyCarPage.currentCarNumber);
    return BlocListener(
      bloc: CardsPage.cardBloc,
      listener: (context, state) {
        print('--------------');
        print(state);
        print('--------------');
        if (state is GetCardsSuccessState) {
          CardsPage.cards.clear();
          var list = state.response.results ?? [];
          if (list.isNotEmpty) {
            CardsPage.cards =
                list.where((cardItem) => cardItem.isVerified).toList();
          }
          // CardsPage.cards = state.response.results ?? [];
          try {
            CardsPage.loading.value = false;
          } catch (e) {}
        }
        if (state is DeleteCardSuccessState) {
          print('there');
          CardsPage.loading.value = false;
          _loadData();
        }
      },
      child: BlocBuilder(
        bloc: CardsPage.cardBloc,
        builder: (context, state) {
          if (state is CardInitial && CardsPage.cards.isEmpty) {
            print("there");
            return Container(
              height: 65.0.h,
              constraints:
                  const BoxConstraints(maxHeight: 550.0, minHeight: 480.0),
              decoration: BoxDecoration(
                  borderRadius:
                      BorderRadius.vertical(top: Radius.circular(10.0))),
              child: const Center(
                child: CircularProgressIndicator(
                  strokeWidth: 3.0,
                  valueColor: AlwaysStoppedAnimation<Color>(
                    AppColors.unSelectedColor,
                  ),
                ),
              ),
            );
          } else if (state is CardLoadingError) {
            return const SizedBox();
          } else {
            return (CardsPage.cards.isEmpty && state is GetCardsSuccessState)
                ? Container(
                    height: 65.0.h,
                    constraints: const BoxConstraints(
                        maxHeight: 550.0, minHeight: 480.0),
                    decoration: const BoxDecoration(
                      borderRadius:
                          BorderRadius.vertical(top: Radius.circular(10.0)),
                    ),
                    child: Column(
                      children: [
                        const SizedBox(height: 8.0),
                        Align(
                          alignment: Alignment.topLeft,
                          child: Padding(
                            padding:
                                const EdgeInsets.symmetric(horizontal: 16.0),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Padding(
                                  padding:
                                      const EdgeInsets.symmetric(vertical: 4.0),
                                  child: Text(
                                    '${S.of(context).fine} ${widget.fineNumberToShow}',
                                    style: AppStyle.textStyle().copyWith(
                                        color: Color(0xff282828),
                                        fontSize: 24.0,
                                        fontWeight: FontWeight.w700),
                                  ),
                                ),
                                Text(
                                  widget.dateTimeToShow,
                                  style: AppStyle.textStyle().copyWith(
                                      color: Color(0xff747474),
                                      fontWeight: FontWeight.w500,
                                      fontSize: 14.0),
                                )
                              ],
                            ),
                          ),
                        ),
                        const SizedBox(height: 30.0),
                        Container(
                          alignment: Alignment.topLeft,
                          margin: const EdgeInsets.symmetric(horizontal: 16.0),
                          height: 30.0,
                          child: Text(
                            S.of(context).cards.toUpperCase(),
                            style: AppStyle.textStyle().copyWith(
                                color: Color(0xff282828),
                                fontSize: 15.0,
                                fontWeight: FontWeight.w600),
                          ),
                        ),
                        Container(
                          height: 20.0,
                          child: Center(
                            child: Container(
                              margin: EdgeInsets.symmetric(horizontal: 15.0.w),
                              height: 1,
                              color: Colors.black26,
                            ),
                          ),
                        ),
                        Container(
                          height: 250.0,
                          child: Center(
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.spaceAround,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Text(
                                  S.of(context).no_cards,
                                  style: AppStyle.textStyle().copyWith(
                                      color: Color(0xff282828),
                                      fontWeight: FontWeight.w600,
                                      fontSize: 20.0),
                                ),
                                GestureDetector(
                                  onTap: widget.onAddCard,
                                  child: Container(
                                    padding: const EdgeInsets.symmetric(
                                        vertical: 10.0, horizontal: 15.0),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(32.0),
                                      color: AppColors.color333333,
                                    ),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      mainAxisSize: MainAxisSize.min,
                                      children: [
                                        const Icon(Icons.add_circle_outline,
                                            color: Colors.white, size: 25.0),
                                        const SizedBox(width: 5.0),
                                        Text(
                                          "${S.of(context).add_card}",
                                          style: AppStyle.textStyle().copyWith(
                                              color: Colors.white,
                                              fontWeight: FontWeight.w500,
                                              fontSize: 20.0),
                                          textAlign: TextAlign.left,
                                          maxLines: 1,
                                          overflow: TextOverflow.ellipsis,
                                        ),
                                        const SizedBox(width: 5.0),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                        Container(
                          height: 20.0,
                          child: Center(
                            child: Container(
                              margin: EdgeInsets.symmetric(horizontal: 15.0.w),
                              height: 1,
                              color: Colors.black26,
                            ),
                          ),
                        ),
                      ],
                    ),
                  )
                : Container(
                    height: 65.0.h,
                    constraints: const BoxConstraints(
                        maxHeight: 550.0, minHeight: 480.0),
                    decoration: const BoxDecoration(
                        borderRadius:
                            BorderRadius.vertical(top: Radius.circular(10.0))),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        const SizedBox(height: 8.0),
                        Align(
                          alignment: Alignment.topLeft,
                          child: Padding(
                            padding:
                                const EdgeInsets.symmetric(horizontal: 16.0),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Padding(
                                  padding:
                                      const EdgeInsets.symmetric(vertical: 4.0),
                                  child: Text(
                                    '${S.of(context).fine} ${widget.fineNumberToShow}',
                                    style: AppStyle.textStyle().copyWith(
                                        color: Color(0xff282828),
                                        fontSize: 24.0,
                                        fontWeight: FontWeight.w700),
                                  ),
                                ),
                                Text(
                                  widget.dateTimeToShow,
                                  style: AppStyle.textStyle().copyWith(
                                      color: Color(0xff747474),
                                      fontWeight: FontWeight.w500,
                                      fontSize: 14.0),
                                )
                              ],
                            ),
                          ),
                        ),
                        const SizedBox(height: 30.0),
                        Container(
                          margin: const EdgeInsets.symmetric(horizontal: 16.0),
                          height: 30.0,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Text(
                                S.of(context).cards.toUpperCase(),
                                style: AppStyle.textStyle().copyWith(
                                    color: Color(0xff282828),
                                    fontSize: 15.0,
                                    fontWeight: FontWeight.w600),
                              ),
                              InkWell(
                                onTap: widget.onAddCard,
                                child: Row(
                                  children: [
                                    const Icon(
                                        Icons.add_circle_outline_rounded),
                                    const SizedBox(width: 3.0),
                                    Text(S.of(context).add_card)
                                  ],
                                ),
                              ),
                            ],
                          ),
                        ),
                        (CardsPage.cards.length > 0)
                            ? ((CardsPage.cards.length > 1)
                                ? Container(
                                    height: 220.0,
                                    width: 100.0.w,
                                    child: CarouselSlider(
                                      items: List.generate(
                                          CardsPage.cards.length, (index) {
                                        return Center(
                                          child: Padding(
                                            padding: const EdgeInsets.symmetric(
                                                vertical: 10.0,
                                                horizontal: 10.0),
                                            child: GestureDetector(
                                              onTap: () {},
                                              child: Material(
                                                borderRadius:
                                                    BorderRadius.circular(13.0),
                                                elevation: 5.0,
                                                child: CardItem(
                                                  card: CardsPage.cards[index],
                                                  gradientId: index % 8,
                                                ),
                                              ),
                                            ),
                                          ),
                                        );
                                      }),
                                      options: CarouselOptions(
                                        enableInfiniteScroll: false,
                                        initialPage: 0,
                                        enlargeCenterPage: true,
                                        onPageChanged: (index, reason) {
                                          setState(
                                            () {
                                              CardBottomSheetItem.currentCard =
                                                  index;
                                            },
                                          );
                                        },
                                      ),
                                    ),
                                  )
                                : Container(
                                    height: 220.0,
                                    child: Center(
                                      child: Padding(
                                        padding: const EdgeInsets.symmetric(
                                            vertical: 10.0),
                                        child: CardItem(
                                          card: CardsPage.cards[0],
                                          gradientId: 0,
                                        ),
                                      ),
                                    ),
                                  ))
                            : SizedBox(),
                        (CardsPage.cards.length > 1)
                            ? Container(
                                height: 20.0,
                                padding:
                                    EdgeInsets.symmetric(horizontal: 15.0.w),
                                child: Row(
                                  children: List.generate(
                                    CardsPage.cards.length,
                                    (index) => Expanded(
                                      child: Container(
                                        height: 3.0,
                                        margin: const EdgeInsets.symmetric(
                                            vertical: 4.0, horizontal: 10.0),
                                        decoration: BoxDecoration(
                                          borderRadius: BorderRadius.all(
                                            Radius.circular(2.0),
                                          ),
                                          color: (index ==
                                                  CardBottomSheetItem
                                                      .currentCard)
                                              ? Color(0xFF282828)
                                              : Color(0xFFC4C4C4),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              )
                            : const SizedBox(
                                height: 20.0,
                              ),
                        Padding(
                          padding: const EdgeInsets.all(16.0),
                          child: CustomButton(
                            onTap: widget.onPay,
                            color: AppColors.colorf51a51,
                            title: S.of(context).pay,
                          ),
                        ),
                      ],
                    ),
                  );
          }
        },
      ),
    );
  }
}
