import 'dart:io';

import 'package:flutter/material.dart';

import 'package:auto_size_text/auto_size_text.dart';

class CarNumber extends StatelessWidget {
  final double? width;
  final String carNumber;
  final double fontSize;

  const CarNumber({this.width, required this.carNumber, this.fontSize = 18});

  int getNumberType(String carNumber) {
    carNumber = carNumber.replaceAll(" ", "");
    final List<RegExp> regexs = [
      RegExp("^UN[0-9]{4}\$"),
      //UN0123 //blue 0
      RegExp("^CMD[0-9]{4}\$"),
      //CMD1234 //green 1
      RegExp("^[A-Z]{1}[0-9]{6}\$"),
      //T012345 //green  2
      RegExp("^PAA[0-9]{3}\$"),
      //PAA123 //white   3
      RegExp("^[A-Z]{1}[0-9]{8}\$"),
      //T01234501 //white  4
      RegExp("^[0-9]{2}M[0-9]{6}\$"),
      //01M123456 //green  5
      RegExp("^[0-9]{2}H[0-9]{6}\$"),
      //01H123456 //orange  6

      RegExp("^[0-9]{5}[A-Z]{2}EEEE"),
      //01123MME //electro yur (hudud yashil)
      RegExp("^[0-9]{2}[A-Z]{1}[0-9]{3}[A-Z]{1}EEEEE"),
      //01M123ME //electro fiz (hudud yashil)
      RegExp("^[0-9]{2}[A-Z]{1}[0-9]{3}[A-Z]{2}\$"),
      //01M123MM //white
      RegExp("^[0-9]{5}[A-Z]{3}\$"),
      //01123MMM //white
      RegExp("^[0-9]{5}[A-Z]{2}\$"),
      //01123MM //white
    ];
    for (int i = 0; i < regexs.length; i++) {
      if (regexs[i].hasMatch(carNumber)) {
        return i;
      }
    }
    return -1;
  }

  Color getBackgroundColor(int type) {
    switch (type) {
      case 0:
        return Colors.blueAccent;
      case 1:
      case 2:
      case 5:
        return Colors.green;

      case 6:
        return Colors.orange;

      // case 7:
      // case 8:
      // case 9:
      // case 11:
      //   return Colors.white;

      default:
        return Colors.white;
    }
  }

  Color getColor(int type) {
    switch (type) {
      case 0:
      case 1:
      case 2:
      case 5:
        return Colors.white;

      case 3:
      case 4:
      case 6:
      case 7:
      case 8:
      case 9:
        // case 10:
        // case 11:
        return Colors.black87;

      default:
        return Colors.black87;
    }
  }

  Widget _circle({
    Color color = Colors.black87,
    double radius = 4,
    double marginLeft = 0,
    double marginRight = 0,
  }) {
    return Container(
      width: radius * 0.5,
      height: radius * 0.5,
      margin: EdgeInsets.only(left: marginLeft, right: marginRight),
      decoration: BoxDecoration(color: color, shape: BoxShape.circle),
    );
  }

  TextStyle getStyle(int type) {
    return TextStyle(
      fontSize: fontSize,
      fontWeight: FontWeight.w400,
      color: getColor(type),
      // letterSpacing: 1,
      fontFamily: "FE Schrift",
    );
  }

  @override
  Widget build(BuildContext context) {
    final double scala = fontSize / 14;
    final String number = carNumber.replaceAll(" ", "");
    final int type = getNumberType(number);
    return Container(
      height: scala * 32,
      width: width,
      padding: EdgeInsets.all(2 * scala),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(6 * scala),
        color: getBackgroundColor(type),
      ),
      child: ClipRRect(
        borderRadius: BorderRadius.circular(6 * scala),
        child: Container(
          padding: EdgeInsets.symmetric(
            horizontal: 4 * scala,
          ),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(6 * scala),
            border: Border.all(color: getColor(type), width: 1 * scala),
            color: getBackgroundColor(type),
          ),
          child: Builder(
            builder: (context) {
              if (type == 0 || type == 1 || type == 2)
                return Row(
                  mainAxisSize: MainAxisSize.min,
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    _circle(radius: 4 * scala, marginRight: 4 * scala),
                    Padding(
                      padding: EdgeInsets.only(
                          bottom: (Platform.isAndroid) ? 7.0 : 0),
                      child: AutoSizeText(
                        type == 0
                            ? " ${number.substring(0, 2)} ${number.substring(2)} "
                            : (type == 1
                                ? " ${number.substring(0, 3)} ${number.substring(3)} "
                                : " ${number[0]} ${number.substring(1)} "),
                        style: getStyle(type),
                      ),
                    ),
                    _circle(radius: 4 * scala, marginLeft: 4 * scala),
                  ],
                );
              if (type == 3)
                return Row(
                  mainAxisSize: MainAxisSize.min,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    _circle(radius: 4 * scala, marginRight: 4 * scala),
                    Image.asset("assets/png/uzb_flag.png", width: 25 * scala),
                    AutoSizeText(
                      " ${number.substring(0, 3)} ${number.substring(3)} ",
                      style: getStyle(type),
                    ),
                    _circle(radius: 4 * scala, marginLeft: 4 * scala),
                  ],
                );
              if (type == 4)
                return Row(
                  mainAxisSize: MainAxisSize.min,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    _circle(radius: 4 * scala, marginRight: 4 * scala),
                    AutoSizeText(
                      " ${number[0]} ${number.substring(1, 7)} ",
                      style: getStyle(type),
                    ),
                    Container(width: scala, color: getColor(type)),
                    AutoSizeText(
                      " ${number.substring(7)}",
                      style: getStyle(type),
                    ),
                    _circle(radius: 4 * scala, marginLeft: 4 * scala),
                  ],
                );
              if (type == 5 || type == 6)
                return Row(
                  mainAxisSize: MainAxisSize.min,
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Align(
                        alignment: Alignment.center,
                        child:
                            _circle(radius: 4 * scala, marginRight: 4 * scala)),
                    Padding(
                      padding: const EdgeInsets.only(top: 8.0),
                      child: AutoSizeText(
                        "${number.substring(0, 2)} ",
                        style: getStyle(type),
                      ),
                    ),
                    Container(width: scala, color: getColor(type)),
                    Padding(
                      padding: const EdgeInsets.only(top: 8.0),
                      child: AutoSizeText(
                        " ${number[2]} ${number.substring(3)} ",
                        style: getStyle(type),
                      ),
                    ),
                    Align(
                      alignment: Alignment.center,
                      child: _circle(radius: 4 * scala, marginLeft: 4 * scala),
                    )
                  ],
                );

              if (type == 9 || type == 10 || type == 11)
                // if (type == 7 || type == 8 || type == 9)
                return Row(
                  mainAxisSize: MainAxisSize.min,
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Align(
                        alignment: Alignment.center,
                        child:
                            _circle(radius: 4 * scala, marginRight: 4 * scala)),
                    //
                    Padding(
                      padding: const EdgeInsets.only(top: 8.0),
                      child: AutoSizeText(
                        "${number.substring(0, 2)} ",
                        style: getStyle(type),
                      ),
                    ),
                    Container(width: scala, color: getColor(type)),
                    Padding(
                      padding: const EdgeInsets.only(top: 8.0),
                      child: AutoSizeText(
                        type == 9
                            ? " ${number[2]} ${number.substring(3, 6)} ${number.substring(6)} "
                            : " ${number.substring(2, 5)} ${number.substring(5)} ",
                        style: getStyle(type),
                        // textAlign: TextAlign.center,
                      ),
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Image.asset(
                          "assets/png/falg.png",
                          fit: BoxFit.fill,
                          height: 10,
                        ),
                        SizedBox(height: 2 * scala),
                        Text("UZ",
                            style: getStyle(type).copyWith(
                              fontSize: 7 * scala,
                              color: Colors.blue,
                            )),
                      ],
                    ),
                    //
                    Align(
                        alignment: Alignment.center,
                        child:
                            _circle(radius: 4 * scala, marginLeft: 4 * scala)),
                  ],
                );

              return Row(
                mainAxisSize: MainAxisSize.min,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  _circle(radius: 4 * scala, marginRight: 4 * scala),
                  AutoSizeText(number, style: getStyle(type)),
                  _circle(radius: 4 * scala, marginLeft: 4 * scala),
                ],
              );
            },
          ),
        ),
      ),
    );
  }
}
