import 'package:flutter/material.dart';
import 'package:mask_text_input_formatter/mask_text_input_formatter.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomTextField extends StatelessWidget {
  final backgroundColor;
  final TextEditingController controller;
  final String text;
  final MaskTextInputFormatter mask;
  final TextInputType inputType;
  final Widget? suffixIcon;
  final String? Function(String?)? validator;
  final String? prefix;
  final TextStyle? style;
  final bool enabled;
  final bool autofocus;
  final int? maxLine;
  final double fontSize;
  final TextCapitalization? textCapitalization;

  const CustomTextField({
    Key? key,
    required this.controller,
    required this.text,
    required this.mask,
    required this.inputType,
    this.suffixIcon,
    this.style,
    this.prefix,
    this.enabled = true,
    this.autofocus = false,
    this.maxLine = 1,
    this.fontSize = 16.0,
    this.textCapitalization,
    this.backgroundColor,
    this.validator,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return TextFormField(
      cursorColor: AppColors.selectedColor,
      maxLines: maxLine,
      enabled: enabled,
      autofocus: autofocus,
      textCapitalization: (textCapitalization != null)
          ? textCapitalization!
          : TextCapitalization.none,
      inputFormatters: [mask],
      keyboardType: inputType,
      controller: controller,
      style: style ??
          AppStyle.textStyle().copyWith(
            color: Color(0xFF959595),
            fontSize: fontSize,
            fontWeight: FontWeight.normal,
          ),
      decoration: InputDecoration(
        prefixText: prefix ?? "",
        prefixStyle: AppStyle.textStyle().copyWith(
            color: Color(0xff282828),
            fontWeight: FontWeight.w500,
            fontSize: 16.0),
        labelText: prefix ?? "",
        floatingLabelBehavior: FloatingLabelBehavior.never,
        suffixIcon: suffixIcon ?? null,
        hintText: text,
        hintStyle: AppStyle.textStyle().copyWith(
          color: AppColors.unSelectedColor,
          fontSize: fontSize,
          fontWeight: FontWeight.normal,
        ),
        filled: true,
        fillColor: (backgroundColor == null)
            ? Color(0xffEFEFEF)
            : this.backgroundColor,
        border: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.transparent),
        ),
        enabledBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Color(0xFFE0E0E0), width: 1.0),
        ),
        focusedBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.black, width: 1.5),
        ),
        contentPadding:
            const EdgeInsets.symmetric(vertical: 15.0, horizontal: 8.0),
      ),
      validator: validator,
    );
  }
}
