import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';

class CustomLoadingIndicator extends StatelessWidget {
  final Color color;
  final double strokeWidth;
  final double? value;
  const CustomLoadingIndicator({
    Key? key,
    this.color = AppColors.indicatorColor,
    this.strokeWidth = 1.0,
    this.value,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return CircularProgressIndicator(
      value: value,
      strokeWidth: strokeWidth,
      valueColor: AlwaysStoppedAnimation<Color>(color),
    );
  }
}
