import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class CustomDialog {
  final String title;
  final String content;
  final Function()? onNoTap;
  final Function()? onYesTap;

  CustomDialog(
      {this.onNoTap,
      this.onYesTap,
      required this.title,
      required this.content});

  showAlertDialog(BuildContext context) {
    Widget cancelButton = TextButton(
      child: Text(
        S.of(context).no,
        style: TextStyle(
          color: AppColors.selectedColor,
          fontSize: 17.0,
          fontWeight: FontWeight.w400,
        ),
      ),
      onPressed: onNoTap,
    );
    Widget continueButton = TextButton(
      child: Text(
        S.of(context).yes,
        style: TextStyle(
          color: AppColors.selectedColor,
          fontSize: 17.0,
          fontWeight: FontWeight.w400,
        ),
      ),
      onPressed: onYesTap,
    );

    // set up the AlertDialog
    var alert = AlertDialog(
      title: Text(
        title,
        style: AppStyle.textStyle().copyWith(
          color: Colors.black,
          fontSize: 22.0,
          fontWeight: FontWeight.w500,
        ),
      ),
      content: Text(
        content,
        style: AppStyle.textStyle().copyWith(
          color: Colors.black,
          fontSize: 17.0,
          fontWeight: FontWeight.w400,
        ),
      ),
      actions: [
        cancelButton,
        continueButton,
      ],
    );

    // show the dialog
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return alert;
      },
    );
  }
}
