import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/data/repository/UploadFileRepository.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:sizer/sizer.dart';

class CustomButton extends StatelessWidget {
  final String title;
  final Function()? onTap;
  final Color? color;
  final TextStyle? textStyle;
  final bool isLoading;
  final String? iconName;
  final String? fileName;

  const CustomButton({
    Key? key,
    required this.title,
    this.onTap,
    this.color,
    this.textStyle,
    this.isLoading = false,
    this.iconName,
    this.fileName,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60.0,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(12.0),
        color: color ?? Color(0xff333333),
        boxShadow: [
          BoxShadow(
              color: color != null
                  ? color!.withOpacity(0.2)
                  : Color(0xff333333).withOpacity(0.1),
              offset: Offset(5.0, 10.0),
              blurRadius: 12.0),
        ],
      ),
      child: IgnorePointer(
        ignoring: isLoading,
        child: InkWell(
          borderRadius: BorderRadius.circular(12.0),
          onTap: onTap ?? () {},
          child: Container(
            padding: const EdgeInsets.all(6.0),
            child: Center(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  if (iconName != null)
                    SvgPicture.asset(
                      iconName!,
                      color: Colors.white,
                    ),
                  if (iconName != null)
                    SizedBox(
                      width: 15.0,
                    ),
                  isLoading
                      ? Container(
                          height: 27.0,
                          width: 27.0,
                          child: ValueListenableBuilder(
                            valueListenable:
                                UploadFileRepository.currentlyUploadingFiles,
                            builder: (context, number, widget) => Stack(
                              alignment: Alignment.center,
                              children: [
                                (UploadFileRepository.currentlyUploadingFiles
                                            .value[fileName] !=
                                        null)
                                    ? CircularProgressIndicator(
                                        value: UploadFileRepository
                                                .currentlyUploadingFiles
                                                .value[fileName]! /
                                            100,
                                        valueColor:
                                            const AlwaysStoppedAnimation<Color>(
                                                Colors.white),
                                        backgroundColor: Colors.grey,
                                        strokeWidth: 1.0,
                                      )
                                    : CircularProgressIndicator(
                                        valueColor:
                                            const AlwaysStoppedAnimation<Color>(
                                                Colors.white),
                                        backgroundColor: Colors.grey,
                                        strokeWidth: 1.0),
                                if ((UploadFileRepository
                                        .currentlyUploadingFiles
                                        .value[fileName] !=
                                    null))
                                  Center(
                                    child: Container(
                                      width: 24.0,
                                      child: Text(
                                        (UploadFileRepository
                                                    .currentlyUploadingFiles
                                                    .value[fileName])!
                                                .ceil()
                                                .toString() +
                                            '%',
                                        style: TextStyle(
                                            fontSize: 6.8.sp,
                                            color: Colors.white),
                                        textAlign: TextAlign.center,
                                      ),
                                    ),
                                  ),
                              ],
                            ),
                          ),
                        )
                      : Container(
                          height: 30.0,
                          child: Center(
                            child: Text(
                              title,
                              style: textStyle ??
                                  AppStyle.textStyle().copyWith(
                                      color: Colors.white,
                                      fontWeight: FontWeight.w600,
                                      fontSize: 18.0),
                            ),
                          ),
                        ),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}
