import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class CustomBottomTabBar extends StatelessWidget {
  final int currentIndex;
  final Function(int) onTap;
  static Map<String, int> indexMap = {
    'MyAvto': 0,
    'ChequeList': 1,
    // 'NotificationPage': 2,
    'Manual': 2,
    'Settings': 3,
  };

  const CustomBottomTabBar(
      {Key? key, required this.currentIndex, required this.onTap})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        backgroundBlendMode: BlendMode.color,
        color: Colors.white.withOpacity(0.53),
      ),
      child: BottomNavigationBar(
        selectedFontSize: 0.0,
        unselectedFontSize: 0.0,
        selectedIconTheme: IconThemeData(size: 0.0),
        unselectedIconTheme: IconThemeData(size: 0.0),
        selectedItemColor: AppColors.selectedColor,
        unselectedItemColor: AppColors.unSelectedColor,
        onTap: onTap,
        currentIndex: currentIndex,
        backgroundColor: Colors.white.withOpacity(0.53),
        type: BottomNavigationBarType.fixed,
        elevation: 0.0,
        items: [
          BottomNavigationBarItem(
              label: '',
              icon: tabBarWidget(Icons.history,
                  CustomBottomTabBar.indexMap['MyAvto'], S.of(context).my_car,
                  svgIconPath: "car")),
          BottomNavigationBarItem(
            label: '',
            icon: tabBarWidget(
              Icons.history,
              CustomBottomTabBar.indexMap['ChequeList'],
              S.of(context).chequeList,
            ),
          ),
          BottomNavigationBarItem(
              label: '',
              icon: tabBarWidget(Icons.line_style_outlined,
                  CustomBottomTabBar.indexMap['Manual'], S.of(context).manual,
                  svgIconPath: "manual")),
          BottomNavigationBarItem(
            label: '',
            icon: tabBarWidget(Icons.settings,
                CustomBottomTabBar.indexMap['Settings'], S.of(context).settings,
                svgIconPath: "settings"),
          ),
        ],
      ),
    );
  }

  tabBarWidget(IconData icon, int? index, String title, {String? svgIconPath}) {
    var color = currentIndex == index
        ? AppColors.selectedColor
        : AppColors.unSelectedColor;
    return Column(
      children: [
        Container(
          width: 30,
          height: 30,
          child: svgIconPath != null
              ? Center(
                  child: SvgPicture.asset(
                    "assets/svg/$svgIconPath.svg",
                    color: color,
                    height: 24.0,
                    width: 30.0,
                  ),
                )
              : Center(
                  child: Icon(
                    icon,
                    size: 30.0,
                    color: color,
                  ),
                ),
        ),
        Text(
          title,
          style: AppStyle.textStyle().copyWith(color: color, fontSize: 11.0),
        ),
      ],
    );
  }
}
