import 'package:barcode_widget/barcode_widget.dart';
import 'package:flutter/material.dart';
import 'package:sizer/sizer.dart';

class BarCodeFullScreen extends StatelessWidget {
  final String barcode;

  const BarCodeFullScreen({Key? key, required this.barcode}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SafeArea(
        child: GestureDetector(
          onTap: () {
            Navigator.of(context).pop();
          },
          child: Stack(
            children: [
              Padding(
                padding: EdgeInsets.symmetric(vertical: 5.0.h),
                child: Center(
                  child: BarcodeWidget(
                    barcode: Barcode.code128(),
                    data: barcode,
                    padding: const EdgeInsets.all(12),
                    width: 80.w,
                    height: 120.0,
                    drawText: false,
                  ),
                ),
              ),
              Align(
                alignment: Alignment.topLeft,
                child: Container(
                  height: 60.0,
                  width: 56.0,
                  child: Material(
                    type: MaterialType.transparency,
                    child: InkWell(
                      onTap: () {
                        Navigator.of(context).pop();
                      },
                      child: Container(
                        alignment: Alignment.bottomLeft,
                        margin: EdgeInsets.symmetric(
                            horizontal: 10.0, vertical: 12.0),
                        decoration: BoxDecoration(
                          color: Color(0xffDFDFDF),
                          shape: BoxShape.circle,
                        ),
                        child: Center(
                          child: Icon(
                            Icons.arrow_back_ios_outlined,
                            size: 20.0,
                            color: Colors.black,
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
