import 'dart:ui';
import 'package:flutter/cupertino.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:sizer/sizer.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:flutter/widgets.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class AddNewPage extends StatelessWidget {
  final Function() onTap;
  final String text;
  final String subText;
  final String btnText;
  const AddNewPage(
      {Key? key,
      required this.onTap,
      required this.text,
      required this.subText,
      required this.btnText})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return ListView(
      shrinkWrap: true,
      children: [
        Padding(
          padding: const EdgeInsets.symmetric(vertical: 3.0),
          child: Container(
            height: 70.0.w,
            child: Image.asset(
              "assets/png/add_new_car_thumb_up.png",
              fit: BoxFit.fitWidth,
            ),
          ),
        ),
        const SizedBox(
          height: 3.0,
        ),
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: 16.0),
          child: Text(
            text,
            style: AppStyle.textStyle().copyWith(
              color: Color(0xff282828),
              fontSize: 24.0,
              fontWeight: FontWeight.bold,
            ),
            textAlign: TextAlign.left,
            maxLines: 2,
            overflow: TextOverflow.ellipsis,
          ),
        ),
        Padding(
          padding: const EdgeInsets.all(16),
          child: Text(
            subText,
            style: AppStyle.textStyle().copyWith(
                color: Color(0xff747474),
                fontWeight: FontWeight.normal,
                fontSize: 15.0),
          ),
        ),
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
          child: Container(
            height: 8.0.h,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(12.0),
              color: Color(0xff333333),
              boxShadow: [
                BoxShadow(
                  color: AppColors.color333333.withOpacity(0.1),
                  offset: Offset(5.0, 10.0),
                  blurRadius: 7.0.sp,
                ),
              ],
            ),
            child: InkWell(
              borderRadius: BorderRadius.circular(12.0),
              onTap: onTap,
              child: Center(
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    const Icon(
                      Icons.add_circle_outline,
                      color: Colors.white,
                    ),
                    const SizedBox(
                      width: 12.0,
                    ),
                    Center(
                      child: Text(
                        btnText,
                        style: AppStyle.textStyle().copyWith(
                            color: Colors.white,
                            fontWeight: FontWeight.w600,
                            fontSize: 16.0),
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        ),
      ],
    );
  }
}
