import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:shimmer/shimmer.dart';

class NotificationShimmer extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      physics: const NeverScrollableScrollPhysics(),
      child: Shimmer.fromColors(
        period: const Duration(milliseconds: 500),
        baseColor: AppColors.unSelectedColor,
        highlightColor: AppColors.color333333,
        child: Column(
          children: List.generate(
            15,
            (index) => Padding(
              padding:
                  const EdgeInsets.symmetric(horizontal: 16.0, vertical: 5.0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const SizedBox(height: 8.0),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        flex: 8,
                        child: Column(
                          children: [
                            Container(
                              height: 10.0,
                              decoration: BoxDecoration(
                                color: AppColors.colorcacaca.withOpacity(0.2),
                                borderRadius: BorderRadius.circular(12.0),
                              ),
                            ),
                            const SizedBox(height: 10.0),
                            Row(
                              children: [
                                Expanded(
                                  flex: 4,
                                  child: Container(
                                    height: 10.0,
                                    decoration: BoxDecoration(
                                      color: AppColors.colorcacaca
                                          .withOpacity(0.2),
                                      borderRadius: BorderRadius.circular(12.0),
                                    ),
                                  ),
                                ),
                                const Expanded(
                                  flex: 1,
                                  child: SizedBox(),
                                )
                              ],
                            ),
                          ],
                        ),
                      ),
                      const SizedBox(width: 25.0),
                      Expanded(
                        flex: 4,
                        child: Container(
                          height: 7.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10.0),
                  Row(
                    children: [
                      Expanded(
                        flex: 4,
                        child: Container(
                          height: 8.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                      const Expanded(
                        flex: 1,
                        child: SizedBox(),
                      ),
                    ],
                  ),
                  const SizedBox(height: 8.0),
                  Row(
                    children: [
                      Expanded(
                        flex: 3,
                        child: Container(
                          height: 8.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                      const Expanded(
                        flex: 1,
                        child: SizedBox(),
                      ),
                    ],
                  ),
                  const SizedBox(height: 18.0),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}
