import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:shimmer/shimmer.dart';
import 'package:sizer/sizer.dart';

class MyAvtoShimmer extends StatelessWidget {
  final bool enabled;
  final bool isAddCar;
  final bool isFines;
  final bool isItems;

  const MyAvtoShimmer({
    this.enabled = true,
    this.isAddCar = true,
    this.isFines = true,
    this.isItems = true,
  });

  @override
  Widget build(BuildContext context) {
    return Shimmer.fromColors(
      enabled: enabled,
      period: const Duration(milliseconds: 500),
      baseColor: AppColors.unSelectedColor,
      highlightColor: AppColors.color333333,
      child: Container(
        height: 92.0.h - 6.0.w,
        child: SingleChildScrollView(
          physics: const NeverScrollableScrollPhysics(),
          child: Column(
            children: [
              const SizedBox(height: 6.0),
              if (isAddCar)
                Container(
                  constraints: const BoxConstraints(maxWidth: 361.0),
                  child: Row(
                    children: [
                      const SizedBox(width: 11.0),
                      Expanded(
                        child: Container(
                          height: 250.0,
                          padding: const EdgeInsets.symmetric(horizontal: 15.0),
                          decoration: BoxDecoration(
                            border: Border.all(
                              color: Colors.black,
                              width: 0.5,
                            ),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      const SizedBox(height: 10.0),
                                      Container(
                                        height: 10.0,
                                        width: 100.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                      const SizedBox(height: 10.0),
                                      Container(
                                        height: 10.0,
                                        width: 80.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                      const SizedBox(height: 30.0),
                                      Container(
                                        height: 40.0,
                                        width: 120.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    height: 80.0,
                                    width: 80.0,
                                    child: Center(
                                      child: Container(
                                        height: 50.0,
                                        width: 50.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                              const SizedBox(height: 10.0),
                              Container(
                                height: 100.0,
                                decoration: BoxDecoration(
                                  color: AppColors.colorcacaca.withOpacity(0.2),
                                  borderRadius: BorderRadius.circular(12.0),
                                ),
                              ),
                              const SizedBox(height: 10.0),
                            ],
                          ),
                        ),
                      ),
                      const SizedBox(width: 11.0),
                    ],
                  ),
                ),
              const SizedBox(height: 10.0),
              if (isFines)
                Container(
                  constraints: const BoxConstraints(maxWidth: 361.0),
                  child: Row(
                    children: [
                      const SizedBox(width: 8.0),
                      Flexible(
                        child: Container(
                          constraints: const BoxConstraints(maxWidth: 345.0),
                          decoration: BoxDecoration(
                            border: Border.all(
                              color: Colors.black,
                              width: 0.5,
                            ),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                          child: Row(
                            children: [
                              const SizedBox(width: 11.0),
                              Expanded(
                                child: Container(
                                  height: 155.0,
                                  padding: const EdgeInsets.all(6.0),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      const SizedBox(height: 10.0),
                                      Container(
                                        height: 50.0,
                                        width: 50.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                      const SizedBox(height: 10.0),
                                      Container(
                                        height: 10.0,
                                        width: 100.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                      const SizedBox(height: 10.0),
                                      Container(
                                        height: 10.0,
                                        width: 180.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                      const SizedBox(height: 10.0),
                                      Container(
                                        height: 10.0,
                                        width: 120.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                      const SizedBox(height: 10.0),
                                    ],
                                  ),
                                ),
                              ),
                              const SizedBox(width: 11.0),
                            ],
                          ),
                        ),
                      ),
                      const SizedBox(width: 8.0),
                    ],
                  ),
                ),
              const SizedBox(height: 11.0),
              if (isItems)
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      width: 166.0,
                      height: 155.0,
                      child: Container(
                        padding: const EdgeInsets.all(6.0),
                        decoration: BoxDecoration(
                          border: Border.all(
                            color: Colors.black,
                            width: 0.5,
                          ),
                          borderRadius: BorderRadius.circular(12.0),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Container(
                                  height: 40.0,
                                  width: 40.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                Container(
                                  height: 30.0,
                                  width: 30.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                            Container(
                              height: 15.0,
                              width: 100.0,
                              decoration: BoxDecoration(
                                color: AppColors.colorcacaca.withOpacity(0.2),
                                borderRadius: BorderRadius.circular(12.0),
                              ),
                            ),
                            const SizedBox(height: 10.0),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  height: 8.0,
                                  width: 150.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 10.0),
                                Container(
                                  height: 8.0,
                                  width: 120.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 12.0),
                                Container(
                                  height: 8.0,
                                  width: 80.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                          ],
                        ),
                      ),
                    ),
                    const SizedBox(width: 11.0),
                    Container(
                      width: 166.0,
                      height: 155.0,
                      child: Container(
                        padding: const EdgeInsets.all(6.0),
                        decoration: BoxDecoration(
                          border: Border.all(
                            color: Colors.black,
                            width: 0.5,
                          ),
                          borderRadius: BorderRadius.circular(12.0),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Container(
                                  height: 40.0,
                                  width: 40.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                Container(
                                  height: 30.0,
                                  width: 30.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                            Container(
                              height: 15.0,
                              width: 100.0,
                              decoration: BoxDecoration(
                                color: AppColors.colorcacaca.withOpacity(0.2),
                                borderRadius: BorderRadius.circular(12.0),
                              ),
                            ),
                            const SizedBox(height: 10.0),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  height: 8.0,
                                  width: 150.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 10.0),
                                Container(
                                  height: 8.0,
                                  width: 120.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 12.0),
                                Container(
                                  height: 8.0,
                                  width: 80.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              SizedBox(height: !isItems ? 0.0 : 11.0),
              if (isItems)
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      width: 166.0,
                      height: 155.0,
                      child: Container(
                        padding: const EdgeInsets.all(6.0),
                        decoration: BoxDecoration(
                          border: Border.all(
                            color: Colors.black,
                            width: 0.5,
                          ),
                          borderRadius: BorderRadius.circular(12.0),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Container(
                                  height: 40.0,
                                  width: 40.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                Container(
                                  height: 30.0,
                                  width: 30.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                            Container(
                              height: 15.0,
                              width: 100.0,
                              decoration: BoxDecoration(
                                color: AppColors.colorcacaca.withOpacity(0.2),
                                borderRadius: BorderRadius.circular(12.0),
                              ),
                            ),
                            const SizedBox(height: 10.0),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  height: 8.0,
                                  width: 150.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 10.0),
                                Container(
                                  height: 8.0,
                                  width: 120.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 12.0),
                                Container(
                                  height: 8.0,
                                  width: 80.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                          ],
                        ),
                      ),
                    ),
                    const SizedBox(width: 11.0),
                    Container(
                      width: 166.0,
                      height: 155.0,
                      child: Container(
                        padding: const EdgeInsets.all(6.0),
                        decoration: BoxDecoration(
                          border: Border.all(
                            color: Colors.black,
                            width: 0.5,
                          ),
                          borderRadius: BorderRadius.circular(12.0),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Container(
                                  height: 40.0,
                                  width: 40.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                Container(
                                  height: 30.0,
                                  width: 30.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                            Container(
                              height: 15.0,
                              width: 100.0,
                              decoration: BoxDecoration(
                                color: AppColors.colorcacaca.withOpacity(0.2),
                                borderRadius: BorderRadius.circular(12.0),
                              ),
                            ),
                            const SizedBox(height: 10.0),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  height: 8.0,
                                  width: 150.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 10.0),
                                Container(
                                  height: 8.0,
                                  width: 120.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                                const SizedBox(height: 12.0),
                                Container(
                                  height: 8.0,
                                  width: 80.0,
                                  decoration: BoxDecoration(
                                    color:
                                        AppColors.colorcacaca.withOpacity(0.2),
                                    borderRadius: BorderRadius.circular(12.0),
                                  ),
                                ),
                              ],
                            ),
                            const SizedBox(height: 4.0),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              const SizedBox(height: 50.0)
            ],
          ),
        ),
      ),
    );
  }
}
