import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/mycar/my_car_page.dart';
import 'package:road24_mobile/view/widgets/items/car_number.dart';
import 'package:shimmer/shimmer.dart';
import 'package:sizer/sizer.dart';

class FinesShimmer extends StatelessWidget {
  const FinesShimmer({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.appPrimaryColor,
      // appBar: AppBar(
      //   leading: Material(
      //     type: MaterialType.transparency,
      //     child: InkWell(
      //       onTap: () {
      //         Navigator.pop(context);
      //       },
      //       child: Container(
      //         margin: const EdgeInsets.all(10.0),
      //         decoration: BoxDecoration(
      //           color: const Color(0xffDFDFDF),
      //           shape: BoxShape.circle,
      //         ),
      //         child: const Center(
      //           child: Icon(
      //             Icons.arrow_back_ios_outlined,
      //             size: 20.0,
      //             color: Colors.black,
      //           ),
      //         ),
      //       ),
      //     ),
      //   ),
      //   bottom: PreferredSize(
      //     preferredSize: Size.fromHeight(30.0),
      //     child: Container(
      //       margin: const EdgeInsets.symmetric(horizontal: 15.0),
      //       child: Row(
      //         children: [
      //           Expanded(
      //             flex: 2,
      //             child: Text(
      //               "${S.of(context).fines}",
      //               style: AppStyle.textStyle().copyWith(
      //                   color: Color(0xff282828),
      //                   fontWeight: FontWeight.w700,
      //                   fontSize: 24.0),
      //               maxLines: 1,
      //               overflow: TextOverflow.ellipsis,
      //             ),
      //           ),
      //           CarNumber(
      //               carNumber: MyCarPage.currentCarNumber!, fontSize: 18.0),
      //         ],
      //       ),
      //     ),
      //   ),
      // ),

      body: Container(
        margin: const EdgeInsets.symmetric(horizontal: 15.0),
        width: 100.0.w,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            const SizedBox(height: 20.0),
            // Container(
            //   height: 50.0,
            //   padding: const EdgeInsets.symmetric(vertical: 5.0),
            //   decoration: BoxDecoration(
            //     color: Color(0xff767680).withOpacity(0.12),
            //     borderRadius: BorderRadius.circular(100.0),
            //   ),
            //   child: Row(
            //     children: <Widget>[
            //       Expanded(
            //         child: Container(
            //           margin: const EdgeInsets.symmetric(horizontal: 5.0),
            //           padding: const EdgeInsets.symmetric(horizontal: 15.0),
            //           decoration: BoxDecoration(
            //             color: Colors.white,
            //             borderRadius: BorderRadius.circular(100.0),
            //           ),
            //           child: Center(
            //             child: Text(
            //               S.of(context).not_paid + '   ',
            //               style: TextStyle(
            //                 color: Color(0xff000000),
            //                 fontWeight: FontWeight.w600,
            //                 fontSize: 15.0,
            //                 height: 1.2,
            //                 letterSpacing: 0.2,
            //               ),
            //             ),
            //           ),
            //         ),
            //       ),
            //       Expanded(
            //         child: Container(
            //           margin: const EdgeInsets.symmetric(horizontal: 5.0),
            //           padding: const EdgeInsets.symmetric(horizontal: 15.0),
            //           decoration: BoxDecoration(
            //             color: Colors.transparent,
            //             borderRadius: BorderRadius.circular(100.0),
            //           ),
            //           child: Center(
            //             child: Text(
            //               S.of(context).history + '   ',
            //               style: TextStyle(
            //                 color: Color(0xff747474),
            //                 fontWeight: FontWeight.w500,
            //                 fontSize: 15.0,
            //                 height: 1.2,
            //                 letterSpacing: 0.2,
            //               ),
            //             ),
            //           ),
            //         ),
            //       ),
            //     ],
            //   ),
            // ),
            Expanded(
              child: Shimmer.fromColors(
                period: const Duration(milliseconds: 500),
                baseColor: AppColors.unSelectedColor,
                highlightColor: AppColors.color333333,
                child: SingleChildScrollView(
                  child: Column(
                    children: List.generate(
                      15,
                      (index) => Padding(
                        padding: const EdgeInsets.symmetric(
                            horizontal: 5.0, vertical: 5.0),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            const SizedBox(height: 10.0),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Expanded(
                                  flex: 8,
                                  child: Column(
                                    children: [
                                      Row(
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: Container(
                                              height: 8.0,
                                              decoration: BoxDecoration(
                                                color: AppColors.colorcacaca
                                                    .withOpacity(0.2),
                                                borderRadius:
                                                    BorderRadius.circular(12.0),
                                              ),
                                            ),
                                          ),
                                          Expanded(flex: 2, child: SizedBox())
                                        ],
                                      ),
                                      SizedBox(height: 20.0),
                                      Container(
                                        height: 8.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colorcacaca
                                              .withOpacity(0.2),
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                                const SizedBox(width: 25.0),
                                const Expanded(flex: 1, child: SizedBox()),
                              ],
                            ),
                            const SizedBox(height: 18.0),
                            Row(
                              children: [
                                Expanded(
                                  flex: 1,
                                  child: Container(
                                    height: 8.0,
                                    decoration: BoxDecoration(
                                      color: AppColors.colorcacaca
                                          .withOpacity(0.2),
                                      borderRadius: BorderRadius.circular(12.0),
                                    ),
                                  ),
                                ),
                                const Expanded(flex: 3, child: SizedBox()),
                              ],
                            ),
                            const SizedBox(height: 18.0),
                            Row(
                              children: [
                                Expanded(
                                  flex: 8,
                                  child: Container(
                                    height: 8.0,
                                    decoration: BoxDecoration(
                                      color: AppColors.colorcacaca
                                          .withOpacity(0.2),
                                      borderRadius: BorderRadius.circular(12.0),
                                    ),
                                  ),
                                ),
                                const Expanded(flex: 1, child: SizedBox()),
                              ],
                            ),
                            const SizedBox(height: 30.0),
                          ],
                        ),
                      ),
                    ),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
