import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:shimmer/shimmer.dart';
import 'package:sizer/sizer.dart';

class FineDetailsShimmer extends StatelessWidget {
  const FineDetailsShimmer({
    Key? key,
  }) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.appPrimaryColor,
      appBar: AppBar(
        toolbarHeight: 60.0,
        leading: Material(
          type: MaterialType.transparency,
          child: InkWell(
            onTap: () {
              Navigator.pop(context);
            },
            child: Container(
              margin: const EdgeInsets.all(10.0),
              decoration: const BoxDecoration(
                color: Color(0xffDFDFDF),
                shape: BoxShape.circle,
              ),
              child: const Center(
                child: Icon(
                  Icons.arrow_back_ios_outlined,
                  size: 20.0,
                  color: Colors.black,
                ),
              ),
            ),
          ),
        ),
        title: Shimmer.fromColors(
          period: const Duration(milliseconds: 500),
          baseColor: AppColors.unSelectedColor,
          highlightColor: AppColors.color333333,
          child: Container(
            height: 30.0,
            width: 200.0,
            decoration: BoxDecoration(
              color: AppColors.colorcacaca.withOpacity(0.2),
              borderRadius: BorderRadius.circular(12.0),
            ),
          ),
        ),
      ),
      body: Shimmer.fromColors(
        period: const Duration(milliseconds: 500),
        baseColor: AppColors.unSelectedColor,
        highlightColor: AppColors.color333333,
        child: ListView(
          // physics: NeverScrollableScrollPhysics(),
          padding: const EdgeInsets.symmetric(vertical: 6.0),
          children: [
            Container(
              margin: EdgeInsets.symmetric(horizontal: 15.0, vertical: 1.0.w),
              child: Container(
                height: 22.0,
                decoration: BoxDecoration(
                  color: AppColors.colorcacaca.withOpacity(0.2),
                  borderRadius: BorderRadius.circular(12.0),
                ),
              ),
              color: Color(0xFFF6AE21),
            ),
            const SizedBox(height: 10.0),
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Padding(
                  padding: const EdgeInsets.symmetric(
                      horizontal: 7.0, vertical: 12.0),
                  child: Row(
                    children: [
                      Expanded(
                        child: Container(
                          height: 100.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                      const SizedBox(width: 7.0),
                      Expanded(
                        child: Container(
                          height: 100.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Center(
                  child: Container(
                    width: 100.0.w - 14.0,
                    height: 100.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 15.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 40.0,
                    width: 120.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 15.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 120.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 20.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 250.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 20.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 82.0.w,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 85.0.w,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 80.0.w,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 20.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 250.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 20.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 15.0,
                    width: 150.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                const SizedBox(height: 5.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 7.0),
                  child: Container(
                    height: 10.0,
                    width: 250.0,
                    decoration: BoxDecoration(
                      color: AppColors.colorcacaca.withOpacity(0.2),
                      borderRadius: BorderRadius.circular(12.0),
                    ),
                  ),
                ),
                Container(
                  width: 235.0,
                  height: 35.0,
                  margin: const EdgeInsets.symmetric(
                      vertical: 10.0, horizontal: 7.0),
                  decoration: BoxDecoration(
                    color: AppColors.color333333,
                    borderRadius: BorderRadius.circular(32.0),
                  ),
                  child: Material(
                    borderRadius: BorderRadius.circular(32.0),
                    type: MaterialType.transparency,
                    shadowColor: Colors.white.withOpacity(0.3),
                    child: Container(
                      padding: const EdgeInsets.symmetric(
                          vertical: 10.0, horizontal: 10.0),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(32.0),
                      ),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Container(
                            height: 100.0,
                            width: 10.0,
                            decoration: BoxDecoration(
                              color: AppColors.colorcacaca.withOpacity(0.2),
                              borderRadius: BorderRadius.circular(12.0),
                            ),
                          ),
                          const SizedBox(width: 5.0),
                          Container(
                            height: 100.0,
                            width: 10.0,
                            decoration: BoxDecoration(
                              color: AppColors.colorcacaca.withOpacity(0.2),
                              borderRadius: BorderRadius.circular(12.0),
                            ),
                          ),
                          const SizedBox(width: 5.0),
                        ],
                      ),
                    ),
                  ),
                ),
                Container(
                  margin: const EdgeInsets.symmetric(horizontal: 15.0),
                  width: 90.0.w,
                  height: 1.0,
                  color: AppColors.colorcacaca,
                ),
                const SizedBox(height: 10.0),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 15.0),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 7.0),
                        child: Container(
                          height: 45.0,
                          width: 150.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                      Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 7.0),
                        child: Container(
                          height: 45.0,
                          width: 150.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
                Container(
                  margin: const EdgeInsets.symmetric(
                      horizontal: 15.0, vertical: 10.0),
                  padding: EdgeInsets.symmetric(horizontal: 6.0),
                  width: 90.0.w,
                  height: 60.0,
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(12.0),
                      color: Color(0xFFFAFAFA)),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        flex: 1,
                        child: Container(
                          margin: const EdgeInsets.symmetric(horizontal: 6.0),
                          padding: const EdgeInsets.all(10.0),
                          decoration: BoxDecoration(
                            color: AppColors.appPrimaryColor,
                            shape: BoxShape.circle,
                          ),
                          constraints: const BoxConstraints(
                              minHeight: 27.0, minWidth: 27.0),
                          child: const Icon(Icons.access_time_outlined),
                        ),
                      ),
                      Expanded(
                        flex: 5,
                        child: Container(
                          height: 100.0,
                          width: 10.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                      const Expanded(
                        flex: 1,
                        child: Icon(Icons.arrow_forward_ios_rounded,
                            color: Color(0xFF747474), size: 20.0),
                      ),
                    ],
                  ),
                ),
                Container(
                  margin: const EdgeInsets.symmetric(
                      horizontal: 15.0, vertical: 10.0),
                  padding: const EdgeInsets.symmetric(horizontal: 6.0),
                  width: 90.0.w,
                  height: 60.0,
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(12.0),
                      color: Color(0xFFFAFAFA)),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        flex: 1,
                        child: Container(
                          margin: const EdgeInsets.symmetric(horizontal: 6.0),
                          padding: const EdgeInsets.all(10.0),
                          decoration: BoxDecoration(
                            color: AppColors.appPrimaryColor,
                            shape: BoxShape.circle,
                          ),
                          constraints: const BoxConstraints(
                              minHeight: 27.0, minWidth: 27.0),
                          child: const Icon(Icons.access_time_outlined),
                        ),
                      ),
                      Expanded(
                        flex: 5,
                        child: Container(
                          height: 100.0,
                          width: 10.0,
                          decoration: BoxDecoration(
                            color: AppColors.colorcacaca.withOpacity(0.2),
                            borderRadius: BorderRadius.circular(12.0),
                          ),
                        ),
                      ),
                      Expanded(
                        flex: 1,
                        child: const Icon(Icons.arrow_forward_ios_rounded,
                            color: Color(0xFF747474), size: 20.0),
                      ),
                    ],
                  ),
                ),
                const SizedBox(height: 30.0),
              ],
            )
          ],
        ),
      ),
    );
  }
}
