import 'dart:ui';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:modal_progress_hud_nsn/modal_progress_hud_nsn.dart';
import 'package:road24_mobile/data/repository/UserRepository.dart';
import 'package:road24_mobile/data/response/UserResponse.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/RegionsModel.dart';
import 'package:road24_mobile/model/blocs/user/user_bloc.dart';
import 'package:road24_mobile/model/models/UserDetails.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/my_app.dart';
import 'package:road24_mobile/utils/frequent_widgets.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/home/dash_board.dart';
import 'package:road24_mobile/view/widgets/custom_bottom_tabbar.dart';
import 'package:road24_mobile/view/widgets/fade_route.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import 'package:road24_mobile/view/widgets/success_page.dart';
import 'package:road24_mobile/view/widgets/text_field_custom_formatter.dart';
import 'package:road24_mobile/utils/extensions.dart';
import 'package:sizer/sizer.dart';
import 'package:intl/intl.dart';
import 'package:translit/translit.dart';

class UserProfilePage extends StatefulWidget {
  final UserResponse response;

  const UserProfilePage({Key? key, required this.response}) : super(key: key);

  @override
  _SettingsPageState createState() => _SettingsPageState();
}

class _SettingsPageState extends State<UserProfilePage> {
  UserBloc userBloc = UserBloc(repository: UserRepository());
  GlobalKey<FormState> _key = GlobalKey();
  List<String> genders = [];
  List<String> gendersToSend = ['male', 'female'];
  String? chosenGenderValue;
  late String chosenGenderValueToSend;
  late DateTime chosenDate;
  bool loading = false;
  late TextEditingController firstNameController;
  late TextEditingController lastNameController;
  late TextEditingController emailController;
  late TextEditingController birthDateController;
  var cityController = TextEditingController();
  List<Regions> regionsList = [];

  @override
  void dispose() {
    firstNameController.dispose();
    lastNameController.dispose();
    emailController.dispose();
    birthDateController.dispose();
    cityController.dispose();
    userBloc.close();
    super.dispose();
  }

  @override
  void initState() {
    firstNameController =
        TextEditingController(text: widget.response.firstName);
    lastNameController = TextEditingController(text: widget.response.lastName);
    // findUserLocation();
    // findUserLocation(widget.response.location!);
    if (widget.response.email != null) {
      emailController = TextEditingController(text: widget.response.email);
    } else {
      emailController = TextEditingController();
    }
    if (widget.response.birthday != null) {
      birthDateController = TextEditingController(
          text: FrequentWidgets.dateTimeToLocal(widget.response.birthday)
              .split(",")[0]);
      AddUserModel.birthDate = DateFormat('yyyy-MM-dd')
          .format(DateTime.parse(widget.response.birthday));
    } else {
      birthDateController = TextEditingController();
    }
    _loadData();
    super.initState();
  }

  // findUserLocation() {
  //   var locationId = MyApp.preferences?.getUserLocation();
  //   // findUserLocation(int location) {
  //   var regions = json.decode(regionsListJson)["data"] as List;

  //   regionsList = regions.map((e) => Regions.fromJson(e)).toList();

  //   var city = regionsList.firstWhere((element) => element.id == locationId,
  //       orElse: () => Regions(id: 0, name: ""));

  //   cityController.text = city.name;
  // }

  _loadData() async {
    userBloc.add(GetUserEvent());
  }

  @override
  Widget build(BuildContext context) {
    if (genders.isEmpty) {
      genders.add(S.of(context).male);
      genders.add(S.of(context).female);
      if (widget.response.gender != '') {
        chosenGenderValue =
            genders[gendersToSend.indexOf(widget.response.gender)];
      }
      if (chosenGenderValue != null) {
        chosenGenderValueToSend =
            gendersToSend[genders.indexOf(chosenGenderValue!)];
      } else {
        // chosenGenderValue = genders[0];
        chosenGenderValueToSend = '';
      }
    }
    return ValueListenableBuilder(
        valueListenable: MyApp.hasInternet,
        builder: (context, hasInternet, _) {
          return (hasInternet as bool)
              ? ModalProgressHUD(
                  inAsyncCall: loading,
                  color: AppColors.unSelectedColor,
                  progressIndicator: CircularProgressIndicator(
                    strokeWidth: 3.0,
                    valueColor: AlwaysStoppedAnimation<Color>(
                      AppColors.unSelectedColor,
                    ),
                  ),
                  child: GestureDetector(
                    onTap: () {
                      FocusScope.of(context).requestFocus(new FocusNode());
                    },
                    child: Scaffold(
                      backgroundColor: Color(0xffF9F9F9),
                      appBar: AppBar(
                        backgroundColor: Colors.transparent,
                        toolbarHeight: 60.0,
                        leading: Material(
                          type: MaterialType.transparency,
                          child: InkWell(
                            onTap: () {
                              Navigator.pop(context);
                            },
                            child: Container(
                              margin: EdgeInsets.all(10.0),
                              decoration: BoxDecoration(
                                color: Color(0xffDFDFDF),
                                shape: BoxShape.circle,
                              ),
                              child: Center(
                                child: Icon(
                                  Icons.arrow_back_ios_new_rounded,
                                  size: 20.0,
                                  color: Colors.black,
                                ),
                              ),
                            ),
                          ),
                        ),
                        title: Text(
                          "${S.of(context).user_profile}",
                          style: AppStyle.textStyle().copyWith(
                              color: Color(0xff282828),
                              fontWeight: FontWeight.w700,
                              fontSize: 20.0),
                          textAlign: TextAlign.left,
                        ),
                        // bottom: PreferredSize(
                        //   preferredSize: Size.fromHeight(30.0),
                        //   child: Container(
                        //     width: (DashBoard.forTablet != null &&
                        //             DashBoard.forTablet.value!)
                        //         ? (60.0.w - 40.0)
                        //         : 90.0.w,
                        //     child:
                        //   ),
                        // ),
                      ),
                      body: BlocListener(
                        bloc: userBloc,
                        listener: (context, state) {
                          if (state is UserUpdateSuccessState) {
                            setState(() {
                              loading = false;
                            });
                            Navigator.push(
                              context,
                              CupertinoPageRoute(
                                builder: (context) => SuccessPage(
                                  text: S.of(context).success,
                                  onTap: () {
                                    DashBoard.activeTab.value =
                                        CustomBottomTabBar
                                            .indexMap['Settings']!;
                                    Navigator.pushAndRemoveUntil(
                                      context,
                                      FadeRoute(
                                        page: DashBoard(),
                                      ),
                                      (route) => false,
                                    );
                                  },
                                  // onTapSkip: () {},
                                ),
                              ),
                            );
                          }
                          if (state is UserLoadingError) {
                            setState(() {
                              loading = false;
                            });
                          }
                        },
                        child: BlocBuilder(
                          bloc: userBloc,
                          builder: (context, state) {
                            return Form(
                              key: _key,
                              child: Padding(
                                padding: EdgeInsets.symmetric(horizontal: 15.0),
                                child: ListView(
                                  children: [
                                    Text(
                                      "${widget.response.phone}",
                                      style: AppStyle.textStyle().copyWith(
                                          color: Colors.black,
                                          fontWeight: FontWeight.w700,
                                          fontSize: 22.0),
                                      maxLines: 2,
                                      overflow: TextOverflow.ellipsis,
                                      textAlign: TextAlign.left,
                                    ),
                                    SizedBox(height: 10.0),
                                    Padding(
                                      padding:
                                          EdgeInsets.symmetric(horizontal: 3.0),
                                      child: Row(
                                        children: [
                                          Text(
                                            S.of(context).first_name,
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xFF959595),
                                                    fontSize: 15.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                          Text(
                                            '*',
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xffF51A51),
                                                    fontSize: 17.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                        ],
                                      ),
                                    ),
                                    TextFormField(
                                      cursorColor: AppColors.selectedColor,
                                      textAlign: TextAlign.left,
                                      controller: firstNameController,
                                      autofocus: false,
                                      keyboardType: TextInputType.text,
                                      inputFormatters: [
                                        CustomTextInputFormatter(20),
                                      ],
                                      textCapitalization:
                                          TextCapitalization.sentences,
                                      decoration: InputDecoration(
                                        hintText: "${S.of(context).first_name}",
                                        hintStyle: TextStyle(
                                          fontSize: 15.0,
                                          color: Color(0xff959595),
                                        ),
                                        border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Colors.transparent),
                                        ),
                                        enabledBorder: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Color(0xFFE0E0E0),
                                              width: 1.0),
                                        ),
                                        fillColor: Color(0xffEFEFEF),
                                        filled: true,
                                        focusedBorder: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Colors.black, width: 1.5),
                                        ),
                                        contentPadding: EdgeInsets.all(15.0),
                                      ),
                                      validator: (value) {
                                        if (value!.isEmpty) {
                                          return S
                                              .of(context)
                                              .validationForEmpty;
                                        } else {
                                          return null;
                                        }
                                      },
                                    ),
                                    SizedBox(height: 10.0),
                                    Padding(
                                      padding:
                                          EdgeInsets.symmetric(horizontal: 3.0),
                                      child: Row(
                                        children: [
                                          Text(
                                            S.of(context).last_name,
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xFF959595),
                                                    fontSize: 15.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                          Text(
                                            '*',
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xffF51A51),
                                                    fontSize: 17.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                        ],
                                      ),
                                    ),
                                    TextFormField(
                                      cursorColor: AppColors.selectedColor,
                                      textAlign: TextAlign.left,
                                      controller: lastNameController,
                                      textCapitalization:
                                          TextCapitalization.sentences,
                                      autofocus: false,
                                      keyboardType: TextInputType.text,
                                      inputFormatters: [
                                        CustomTextInputFormatter(20),
                                      ],
                                      decoration: InputDecoration(
                                        hintText: "${S.of(context).last_name}",
                                        hintStyle: TextStyle(
                                          fontSize: 15.0,
                                          color: Color(0xff959595),
                                        ),
                                        border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Colors.transparent),
                                        ),
                                        enabledBorder: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Color(0xFFE0E0E0),
                                              width: 1.0),
                                        ),
                                        fillColor: Color(0xffEFEFEF),
                                        filled: true,
                                        focusedBorder: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Colors.black, width: 1.5),
                                        ),
                                        contentPadding: EdgeInsets.all(15.0),
                                      ),
                                      validator: (value) {
                                        if (value!.isEmpty) {
                                          return S
                                              .of(context)
                                              .validationForEmpty;
                                        } else {
                                          return null;
                                        }
                                      },
                                    ),
                                    SizedBox(height: 10.0),
                                    // Padding(
                                    //   padding: EdgeInsets.symmetric(
                                    //       horizontal: 3.0),
                                    //   child: Row(
                                    //     children: [
                                    //       Text(
                                    //         S.of(context).userLocation,
                                    //         style: AppStyle.textStyle()
                                    //             .copyWith(
                                    //                 color:
                                    //                     Color(0xFF959595),
                                    //                 fontSize: 15.0,
                                    //                 fontWeight: FontWeight
                                    //                     .normal),
                                    //       ),
                                    //       Text(
                                    //         '*',
                                    //         style: AppStyle.textStyle()
                                    //             .copyWith(
                                    //                 color:
                                    //                     Color(0xffF51A51),
                                    //                 fontSize: 17.0,
                                    //                 fontWeight: FontWeight
                                    //                     .normal),
                                    //       ),
                                    //     ],
                                    //   ),
                                    // ),
                                    // // InkWell(
                                    //   onTap: () async {
                                    //     await showDialog(
                                    //         context: context,
                                    //         builder: (_context) {
                                    //           return AskUserLocation();
                                    //         });
                                    //     findUserLocation();
                                    //   },
                                    //   child: IgnorePointer(
                                    //     ignoring: true,
                                    //     child: TextFormField(
                                    //       cursorColor:
                                    //           AppColors.selectedColor,
                                    //       textAlign: TextAlign.left,
                                    //       controller: cityController,
                                    //       textCapitalization:
                                    //           TextCapitalization
                                    //               .sentences,
                                    //       readOnly: true,
                                    //       autofocus: false,
                                    //       keyboardType:
                                    //           TextInputType.text,
                                    //       inputFormatters: [
                                    //         CustomTextInputFormatter(20),
                                    //       ],
                                    //       decoration: InputDecoration(
                                    //         suffixIcon: Icon(
                                    //           Icons.location_on,
                                    //           color:
                                    //               AppColors.selectedColor,
                                    //         ),
                                    //         hintText:
                                    //             "${S.of(context).last_name}",
                                    //         hintStyle: TextStyle(
                                    //           fontSize: 15.0,
                                    //           color: Color(0xff959595),
                                    //         ),
                                    //         border: OutlineInputBorder(
                                    //           borderRadius:
                                    //               BorderRadius.circular(
                                    //                   12.0),
                                    //           borderSide: BorderSide(
                                    //               color:
                                    //                   Colors.transparent),
                                    //         ),
                                    //         enabledBorder:
                                    //             OutlineInputBorder(
                                    //           borderRadius:
                                    //               BorderRadius.circular(
                                    //                   12.0),
                                    //           borderSide: BorderSide(
                                    //               color:
                                    //                   Color(0xFFE0E0E0),
                                    //               width: 1.0),
                                    //         ),
                                    //         fillColor: Color(0xffEFEFEF),
                                    //         filled: true,
                                    //         focusedBorder:
                                    //             OutlineInputBorder(
                                    //           borderRadius:
                                    //               BorderRadius.circular(
                                    //                   12.0),
                                    //           borderSide: BorderSide(
                                    //               color: Colors.black,
                                    //               width: 1.5),
                                    //         ),
                                    //         contentPadding:
                                    //             EdgeInsets.all(15.0),
                                    //       ),
                                    //       validator: (value) {
                                    //         if (value!.isEmpty) {
                                    //           return S
                                    //               .of(context)
                                    //               .validationForEmpty;
                                    //         } else {
                                    //           return null;
                                    //         }
                                    //       },
                                    //     ),
                                    //   ),
                                    // ),

                                    // SizedBox(height: 10.0),

                                    Padding(
                                      padding:
                                          EdgeInsets.symmetric(horizontal: 3.0),
                                      child: Text(
                                        'Email',
                                        style: AppStyle.textStyle().copyWith(
                                            color: Color(0xFF959595),
                                            fontSize: 15.0,
                                            fontWeight: FontWeight.normal),
                                      ),
                                    ),
                                    TextFormField(
                                      cursorColor: AppColors.selectedColor,
                                      textAlign: TextAlign.left,
                                      controller: emailController,
                                      autofocus: false,
                                      keyboardType: TextInputType.text,
                                      inputFormatters: [
                                        CustomTextInputFormatter(40),
                                      ],
                                      decoration: InputDecoration(
                                        hintText: "${S.of(context).email}",
                                        hintStyle: TextStyle(
                                          fontSize: 15.0,
                                          color: Color(0xff959595),
                                        ),
                                        border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Colors.transparent),
                                        ),
                                        enabledBorder: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Color(0xFFE0E0E0),
                                              width: 1.0),
                                        ),
                                        fillColor: Color(0xffEFEFEF),
                                        filled: true,
                                        focusedBorder: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(12.0),
                                          borderSide: BorderSide(
                                              color: Colors.black, width: 1.5),
                                        ),
                                        contentPadding: EdgeInsets.all(15.0),
                                      ),
                                      validator: (String? string) {
                                        // Null or empty string is invalid
                                        if (string == null || string.isEmpty) {
                                          return null;
                                        }

                                        const pattern =
                                            r'^[\w-\.]+@([\w-]+\.)+[\w-]{2,4}$';
                                        final regExp = RegExp(pattern);

                                        if (!regExp.hasMatch(string)) {
                                          return S
                                              .of(context)
                                              .validationForEmail;
                                        }
                                        return null;
                                      },
                                    ),
                                    SizedBox(height: 10.0),
                                    Row(
                                      children: [
                                        Expanded(
                                          child: Padding(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 3.0),
                                            child: Text(
                                              S.of(context).gender,
                                              style: AppStyle.textStyle()
                                                  .copyWith(
                                                      color: Color(0xFF959595),
                                                      fontSize: 15.0,
                                                      fontWeight:
                                                          FontWeight.normal),
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 15.0),
                                        Expanded(
                                          child: Padding(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 3.0),
                                            child: Text(
                                              S.of(context).birth_date,
                                              style: AppStyle.textStyle()
                                                  .copyWith(
                                                      color: Color(0xFF959595),
                                                      fontSize: 15.0,
                                                      fontWeight:
                                                          FontWeight.normal),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Container(
                                            height: 50.0,
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 15.0),
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(12.0),
                                              color: Color(0xffEFEFEF),
                                            ),
                                            child: Center(
                                              child: DropdownButton(
                                                isExpanded: true,
                                                underline: SizedBox(),
                                                items:
                                                    genders.map((String value) {
                                                  return DropdownMenuItem<
                                                      String>(
                                                    value: value,
                                                    child: Text(
                                                      value,
                                                      style:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                      maxLines: 1,
                                                    ),
                                                  );
                                                }).toList(),
                                                onChanged: (String? value) {
                                                  setState(() {
                                                    chosenGenderValue = value!;
                                                    chosenGenderValueToSend =
                                                        gendersToSend[
                                                            genders.indexOf(
                                                                chosenGenderValue!)];
                                                  });
                                                },
                                                hint: Text(
                                                  chosenGenderValue ??
                                                      '${S.of(context).gender}',
                                                  style: TextStyle(
                                                    fontSize: 17.0,
                                                    fontWeight: FontWeight.w300,
                                                  ),
                                                  maxLines: 1,
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 15.0),
                                        Expanded(
                                          child: InkWell(
                                            onTap: () {
                                              showDatePicker(
                                                context: context,
                                                initialDate: DateTime.now(),
                                                firstDate: DateTime(1900),
                                                lastDate: DateTime.now(),
                                                locale: Locale(
                                                    (Config.language != 'oz')
                                                        ? Config.language
                                                        : 'uz'),
                                              ).then(
                                                (value) => {
                                                  this.setState(() {
                                                    try {
                                                      chosenDate = value!;
                                                      AddUserModel.birthDate =
                                                          DateFormat(
                                                                  'yyyy-MM-dd')
                                                              .format(
                                                                  chosenDate);
                                                      birthDateController
                                                          .text = (Config
                                                                  .language !=
                                                              'oz')
                                                          ? DateFormat(
                                                                  'dd-MMM yyyy',
                                                                  Config
                                                                      .language)
                                                              .format(value)
                                                          : Translit()
                                                              .unTranslit(
                                                                  source: DateFormat(
                                                                          'dd-MMM yyyy',
                                                                          'uz')
                                                                      .format(
                                                                          value))
                                                              .monthReplacement();
                                                    } catch (_) {}
                                                  }),
                                                },
                                              );
                                            },
                                            child: IgnorePointer(
                                              ignoring: true,
                                              child: Container(
                                                height: 50.0,
                                                child: Center(
                                                  child: TextFormField(
                                                    cursorColor:
                                                        AppColors.selectedColor,
                                                    controller:
                                                        birthDateController,
                                                    keyboardType:
                                                        TextInputType.text,
                                                    decoration: InputDecoration(
                                                      hintText: 'дд.мм.гг',
                                                      hintStyle:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                      border:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors
                                                                .transparent),
                                                      ),
                                                      enabledBorder:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors
                                                                .transparent),
                                                      ),
                                                      fillColor:
                                                          Color(0xffEFEFEF),
                                                      filled: true,
                                                      focusedBorder:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors.black,
                                                            width: 1.5),
                                                      ),
                                                      contentPadding:
                                                          EdgeInsets.all(15.0),
                                                      errorMaxLines: 2,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Container(
                                      margin: EdgeInsets.only(
                                          bottom: 30.0, top: 15.0),
                                      decoration: BoxDecoration(
                                        color: Colors.black,
                                        borderRadius:
                                            BorderRadius.circular(12.0),
                                      ),
                                      child: Material(
                                        borderRadius:
                                            BorderRadius.circular(12.0),
                                        type: MaterialType.transparency,
                                        shadowColor:
                                            Colors.white.withOpacity(0.3),
                                        child: InkWell(
                                          onTap: () {
                                            AddUserModel.firstName =
                                                firstNameController.text;
                                            AddUserModel.lastName =
                                                lastNameController.text;
                                            AddUserModel.email =
                                                emailController.text;
                                            AddUserModel.gender =
                                                chosenGenderValueToSend;
                                            setState(() {
                                              loading = true;
                                            });
                                            if (_key.currentState!.validate()) {
                                              userBloc.add(UpdateUserEvent(
                                                  firstName:
                                                      AddUserModel.firstName,
                                                  lastName:
                                                      AddUserModel.lastName,
                                                  gender: AddUserModel.gender,
                                                  email: AddUserModel.email,
                                                  birthday:
                                                      "${AddUserModel.birthDate}T00:00"));
                                            } else {
                                              setState(() {
                                                loading = false;
                                              });
                                            }
                                          },
                                          child: Container(
                                            width: 90.0.w,
                                            height: 60.0,
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 6.0, vertical: 5.0),
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(32.0),
                                            ),
                                            child: Center(
                                              child: Padding(
                                                padding: EdgeInsets.symmetric(
                                                    horizontal: 6.0),
                                                child: Text(
                                                  S.of(context).save,
                                                  style: AppStyle.textStyle()
                                                      .copyWith(
                                                          color: Colors.white,
                                                          fontWeight:
                                                              FontWeight.w600,
                                                          fontSize: 16.0),
                                                  textAlign: TextAlign.center,
                                                  maxLines: 1,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                    )
                                  ],
                                ),
                              ),
                            );
                          },
                        ),
                      ),
                    ),
                  ),
                )
              : NoConnectionScreen(
                  onTap: () {
                    Navigator.pushReplacement(
                      context,
                      FadeRoute(
                          page: UserProfilePage(
                        response: widget.response,
                      )),
                    );
                  },
                );
        });
  }
}
