import 'dart:io';
import 'dart:math';
import 'dart:ui';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:sizer/sizer.dart';
import 'package:flutter/material.dart';
import 'attachment_icon.dart';

class ChatInput extends StatefulWidget {
  final Function(String) sendTextMessage;
  final Function(File) sendFileMessage;
  final VoidCallback onTextfieldTap;

  const ChatInput(
      {Key? key,
      required this.sendTextMessage,
      required this.onTextfieldTap,
      required this.sendFileMessage})
      : super(key: key);

  @override
  _ChatInputState createState() => _ChatInputState();
}

class _ChatInputState extends State<ChatInput> {
  TextEditingController controller = TextEditingController();
  double angle = pi / 2;

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      color: AppColors.appPrimaryColor,
      padding: EdgeInsets.only(right: 15.0, bottom: 2.h, top: 1.0.h),
      // margin: EdgeInsets.only(top: 1.0.h),
      child: Row(
        children: <Widget>[
          // AppEdgeInsets.horizontalSpace15,

          Container(
            margin: const EdgeInsets.symmetric(horizontal: 10.0),
            decoration: BoxDecoration(
              shape: BoxShape.circle,
              color: Colors.blue,
            ),
            child: Padding(
              padding: const EdgeInsets.all(14.0),
              child: Transform.rotate(
                angle: pi / 4,
                child: AttachmentsIcon(
                  icon: Icons.attach_file,
                  sendAttachmentFile: widget.sendFileMessage,
                ),
              ),
            ),
          ),
          Flexible(
            child: Container(
              width: SizerUtil.deviceType == DeviceType.tablet
                  ? MediaQuery.of(context).size.width * 0.95
                  : MediaQuery.of(context).size.width * 0.75,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(9.0),
                  border: Border.all(color: Color(0xffAAB0B7))),
              child: Row(
                children: [
                  Expanded(
                    child: Padding(
                      padding: const EdgeInsets.only(
                          left: 15.0, top: 5.0, bottom: 5.0),
                      child: TextField(
                        minLines: 1,
                        maxLines: 4,
                        controller: controller,
                        decoration: InputDecoration(
                          hintText: 'Text',
                          fillColor: Colors.transparent,
                          border: InputBorder.none,
                          focusedBorder: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          errorBorder: InputBorder.none,
                          disabledBorder: InputBorder.none,
                        ),
                        onTap: widget.onTextfieldTap,
                      ),
                    ),
                  ),
                  GestureDetector(
                    // color: Theme.of(context).primaryColor,
                    child: Container(
                      padding: const EdgeInsets.symmetric(
                          vertical: 12.0, horizontal: 12.0),
                      child: Icon(
                        Icons.send,
                        size: 25.0,
                        color: Colors.blue,
                      ),
                    ),
                    onTap: () {
                      widget.sendTextMessage(controller.text);
                      controller.clear();
                    },
                  ),
                ],
              ),
            ),
          ),
          const SizedBox(width: 3.0),
        ],
      ),
    );
  }
}
