import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';

class AttachmentsIcon extends StatelessWidget {
  final margin;
  final IconData icon;
  final Function(File) sendAttachmentFile;

  const AttachmentsIcon({
    Key? key,
    required this.icon,
    this.margin,
    required this.sendAttachmentFile,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () async {
        FilePickerResult? result = await FilePicker.platform
            .pickFiles(allowMultiple: false, type: FileType.any);
        // List<File> files;
        File files;
        if (result != null) {
          // files = result.paths.map((path) => File(path)).toList();
          files = File(result.files.single.path);
          sendAttachmentFile(files);
        } else {
          // User canceled the picker
        }
      },
      child: Container(
        margin: margin ?? const EdgeInsets.symmetric(vertical: 5.0),
        decoration: BoxDecoration(
          boxShadow: [
            BoxShadow(
              color: Colors.black54.withOpacity(0.15),
              spreadRadius: 2,
              blurRadius: 5,
              offset: const Offset(0.5, 4), // changes position of shadow
            ),
          ],
          shape: BoxShape.circle,
        ),
        child: Icon(icon, color: Colors.white, size: 28.0),
      ),
    );
  }
}
