// import 'dart:ui';
// import 'package:flutter/cupertino.dart';
// import 'package:sizer/sizer.dart';
// import 'package:cached_network_image/cached_network_image.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:road24_mobile/data/repository/NewsRepository.dart';
// import 'package:road24_mobile/data/response/NewsResponse.dart';
// import 'package:road24_mobile/model/blocs/news/news_bloc.dart';
// import 'package:road24_mobile/model/utils/styles/AppColors.dart';
// import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
// import 'package:road24_mobile/view/built/i18n.dart';
// import 'package:road24_mobile/view/news/news_details_page.dart';
// import 'package:road24_mobile/view/widgets/custom_loading_indicator.dart';
// import 'package:road24_mobile/view/widgets/page_loading.dart';
// import 'package:road24_mobile/view/widgets/items/news_list_item.dart';

// class NewsPage extends StatefulWidget {
//   @override
//   _NewsPageState createState() => _NewsPageState();
// }

// class _NewsPageState extends State<NewsPage> {
//   NewsBloc bloc = NewsBloc(repository: NewsRepository());
//   List<NewsResults> list = [];

//   @override
//   void initState() {
//     super.initState();
//     _loadData();
//   }

//   @override
//   void dispose() {
//     super.dispose();
//     bloc.close();
//   }

//   _loadData() {
//     bloc.add(
//       GetNewsEvent(),
//     );
//   }

//   @override
//   Widget build(BuildContext context) {
//     Size size = MediaQuery.of(context).size;
//     return Scaffold(
//       backgroundColor: AppColors.appPrimaryColor,
//       body: BlocListener(
//         bloc: bloc,
//         listener: (context, state) {},
//         child: BlocBuilder(
//           bloc: bloc,
//           builder: (context, state) {
//             if (state is NewsInitial) {
//               return Center(child: PageLoading());
//             }

//             if (state is NewsLoadingError) {
//               return SizedBox();
//             }

//             if (state is GetNewsSuccessState) {
//               list = state.response.results ?? [];
//               return RefreshIndicator(
//                 color: Colors.black,
//                 onRefresh: () async {
//                   _loadData();
//                 },
//                 child: list.isEmpty
//                     ? Container(
//                         child: Center(
//                           child: Text(
//                             "${S.of(context).no_news}",
//                             style: AppStyle.textStyle().copyWith(
//                                 color: Color(0xFF959595),
//                                 fontWeight: FontWeight.w500,
//                                 fontSize: 17.0),
//                           ),
//                         ),
//                       )
//                     : SingleChildScrollView(
//                         child: Padding(
//                           padding: const EdgeInsets.symmetric(horizontal: 20.0),
//                           child: Column(
//                             children: [
//                               Material(
//                                 type: MaterialType.transparency,
//                                 child: InkWell(
//                                   onTap: () {
//                                     Navigator.push(
//                                       context,
//                                       CupertinoPageRoute(
//                                         builder: (context) {
//                                           return NewsDetailsPage(
//                                             id: list[0].id!,
//                                           );
//                                         },
//                                       ),
//                                     );
//                                   },
//                                   child: Container(
//                                     color: Colors.transparent,
//                                     child: Column(
//                                       children: [
//                                         Container(
//                                           margin: EdgeInsets.symmetric(
//                                               vertical: 10.0),
//                                           width: size.width,
//                                           height: size.height * 0.3,
//                                           decoration: BoxDecoration(
//                                             borderRadius:
//                                                 BorderRadius.circular(7.0.sp),
//                                           ),
//                                           child: ClipRRect(
//                                             borderRadius:
//                                                 BorderRadius.circular(7.0.sp),
//                                             child: CachedNetworkImage(
//                                               imageUrl: list[0].photo!.file!,
//                                               fit: BoxFit.fill,
//                                               placeholder: (context, url) {
//                                                 return Container(
//                                                   padding: EdgeInsets.all(
//                                                       size.width * 0.1),
//                                                   child: Center(
//                                                     child: AspectRatio(
//                                                         aspectRatio: 1.0,
//                                                         child:
//                                                             CustomLoadingIndicator(
//                                                           color: AppColors
//                                                               .selectedColor,
//                                                         )),
//                                                   ),
//                                                 );
//                                               },
//                                               errorWidget: (context, imageUrl,
//                                                   newValue) {
//                                                 return Icon(
//                                                   Icons.image,
//                                                   size: 24.0,
//                                                   color:
//                                                       AppColors.selectedColor,
//                                                 );
//                                               },
//                                             ),
//                                           ),
//                                         ),
//                                         Row(
//                                           children: [
//                                             Expanded(
//                                               flex: 2,
//                                               child: Text(
//                                                 "Ташкент. 16 сен 2020",
//                                                 style: AppStyle.textStyle()
//                                                     .copyWith(
//                                                         color:
//                                                             Color(0xff747474),
//                                                         fontWeight:
//                                                             FontWeight.w400,
//                                                         fontSize: 14.0),
//                                                 maxLines: 1,
//                                                 overflow: TextOverflow.ellipsis,
//                                               ),
//                                             ),
//                                             Expanded(
//                                               flex: 1,
//                                               child: Text(
//                                                 "${list[0].jobType}",
//                                                 style: AppStyle.textStyle()
//                                                     .copyWith(
//                                                   fontWeight: FontWeight.w500,
//                                                   fontSize: 13.0,
//                                                   color: Color(0xffE4702F),
//                                                 ),
//                                                 textAlign: TextAlign.end,
//                                                 maxLines: 1,
//                                                 overflow: TextOverflow.ellipsis,
//                                               ),
//                                             ),
//                                           ],
//                                         ),
//                                         SizedBox(height: 8.0),
//                                         Row(
//                                           children: [
//                                             Expanded(
//                                               child: Text(
//                                                 "${list[0].title}",
//                                                 style: AppStyle.textStyle()
//                                                     .copyWith(
//                                                         color:
//                                                             Color(0xff282828),
//                                                         fontWeight:
//                                                             FontWeight.w500,
//                                                         fontSize: 17.0),
//                                                 maxLines: 2,
//                                                 overflow: TextOverflow.ellipsis,
//                                               ),
//                                             ),
//                                           ],
//                                         ),
//                                         SizedBox(height: 20.0),
//                                       ],
//                                     ),
//                                   ),
//                                 ),
//                               ),
//                               ListView.builder(
//                                 physics: NeverScrollableScrollPhysics(),
//                                 shrinkWrap: true,
//                                 itemCount: list.length,
//                                 itemBuilder: (context, index) {
//                                   return NewsListItem(
//                                     item: list[index],
//                                     onTap: () {
//                                       Navigator.push(
//                                         context,
//                                         CupertinoPageRoute(
//                                           builder: (context) {
//                                             return NewsDetailsPage(
//                                               id: list[index].id!,
//                                             );
//                                           },
//                                         ),
//                                       );
//                                     },
//                                   );
//                                 },
//                               ),
//                             ],
//                           ),
//                         ),
//                       ),
//               );
//             }
//             return SizedBox();
//           },
//         ),
//       ),
//     );
//   }
// }
