// import 'package:cached_network_image/cached_network_image.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:road24_mobile/data/repository/NewsRepository.dart';
// import 'package:road24_mobile/data/response/NewsResponse.dart';
// import 'package:road24_mobile/model/blocs/news/news_bloc.dart';
// import 'package:road24_mobile/model/utils/Config.dart';
// import 'package:road24_mobile/model/utils/styles/AppColors.dart';
// import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
// import 'package:road24_mobile/view/widgets/custom_loading_indicator.dart';
// import 'package:road24_mobile/view/widgets/page_loading.dart';
// import 'package:sizer/sizer.dart';

// class NewsDetailsPage extends StatefulWidget {
//   final num id;

//   const NewsDetailsPage({Key? key, required this.id}) : super(key: key);

//   @override
//   _NewsDetailsPageState createState() => _NewsDetailsPageState();
// }

// class _NewsDetailsPageState extends State<NewsDetailsPage> {
//   NewsBloc bloc = NewsBloc(repository: NewsRepository());
//   late NewsResults results;

//   @override
//   void initState() {
//     super.initState();
//     _loadData();
//   }

//   @override
//   void dispose() {
//     super.dispose();
//     bloc.close();
//   }

//   _loadData() async {
//     print("ID ${widget.id}");
//     bloc.add(
//       ReadNewsEvent(id: widget.id),
//     );
//   }

//   @override
//   Widget build(BuildContext context) {
//     SizedBox _size = SizedBox(
//       height: 10.0,
//     );
//     Size size = MediaQuery.of(context).size;
//     return Scaffold(
//       backgroundColor: AppColors.appPrimaryColor,
//       appBar: AppBar(
//         leading: Material(
//           type: MaterialType.transparency,
//           child: InkWell(
//             onTap: () {
//               Navigator.pop(context);
//             },
//             child: Container(
//               padding: EdgeInsets.all(2.0.w),
//               margin: EdgeInsets.all(8.0),
//               decoration: BoxDecoration(
//                 color: Color(0xffDFDFDF),
//                 shape: BoxShape.circle,
//               ),
//               child: Icon(Icons.arrow_back_ios_rounded, size: 20.0),
//             ),
//           ),
//         ),
//       ),
//       body: BlocListener(
//         bloc: bloc,
//         listener: (context, state) {},
//         child: BlocBuilder(
//           bloc: bloc,
//           builder: (context, state) {
//             if (state is NewsInitial) {
//               return Center(child: PageLoading());
//             }

//             if (state is NewsLoadingError) {
//               return SizedBox();
//             }

//             if (state is ReadNewsSuccessState) {
//               results = state.results;
//               return RefreshIndicator(
//                 color: Colors.black,
//                 onRefresh: () async {
//                   _loadData();
//                 },
//                 child: ListView(
//                   children: [
//                     SizedBox(height: 20.0),
//                     Row(
//                       children: [
//                         SizedBox(width: 20.0),
//                         Expanded(
//                           flex: 2,
//                           child: Text(
//                             "Ташкент. 16 сен 2020",
//                             style: AppStyle.textStyle().copyWith(
//                                 color: Color(0xff747474),
//                                 fontWeight: FontWeight.w400,
//                                 fontSize: 14.0),
//                             maxLines: 1,
//                             overflow: TextOverflow.ellipsis,
//                           ),
//                         ),
//                         Expanded(
//                           flex: 1,
//                           child: Text(
//                             "${results.jobType}",
//                             style: AppStyle.textStyle().copyWith(
//                               fontWeight: FontWeight.w500,
//                               fontSize: 13.0,
//                               color: Color(0xff009821),
//                             ),
//                             textAlign: TextAlign.end,
//                             maxLines: 1,
//                             overflow: TextOverflow.ellipsis,
//                           ),
//                         ),
//                         SizedBox(width: 20.0),
//                       ],
//                     ),
//                     _size,
//                     Row(
//                       children: [
//                         SizedBox(width: 20.0),
//                         Expanded(
//                           child: Text(
//                             "${results.title}",
//                             style: AppStyle.textStyle().copyWith(
//                                 color: Color(0xff282828),
//                                 fontWeight: FontWeight.w500,
//                                 fontSize: 22.0),
//                             maxLines: 5,
//                             overflow: TextOverflow.ellipsis,
//                           ),
//                         ),
//                         SizedBox(width: 20.0),
//                       ],
//                     ),
//                     Container(
//                       margin: EdgeInsets.symmetric(vertical: 10.0),
//                       width: size.width,
//                       height: size.height * 0.3,
//                       child: CachedNetworkImage(
//                         imageUrl: "${Config.baseFilesApiUrl}${results.id}/",
//                         fit: BoxFit.fitWidth,
//                         placeholder: (context, url) {
//                           return Container(
//                             padding: EdgeInsets.all(size.width * 0.1),
//                             child: Center(
//                               child: AspectRatio(
//                                   aspectRatio: 1.0,
//                                   child: CustomLoadingIndicator(
//                                     color: AppColors.selectedColor,
//                                   )),
//                             ),
//                           );
//                         },
//                         errorWidget: (context, imageUrl, newValue) {
//                           return Icon(
//                             Icons.image,
//                             size: 24.0,
//                             color: AppColors.selectedColor,
//                           );
//                         },
//                       ),
//                     ),
//                     Row(
//                       children: [
//                         SizedBox(width: 20.0),
//                         Expanded(
//                           child: Text(
//                             "${results.title}",
//                             style: AppStyle.textStyle().copyWith(
//                                 color: Color(0xff282828),
//                                 fontWeight: FontWeight.w600,
//                                 fontSize: 16.0),
//                             maxLines: 3,
//                             overflow: TextOverflow.ellipsis,
//                           ),
//                         ),
//                         SizedBox(width: 20.0),
//                       ],
//                     ),
//                     _size,
//                     _size,
//                     Row(
//                       children: [
//                         SizedBox(width: 20.0),
//                         Expanded(
//                           child: Text(
//                             "${results.description}",
//                             style: AppStyle.textStyle().copyWith(
//                                 color: Color(0xff282828),
//                                 fontWeight: FontWeight.normal,
//                                 fontSize: 15.0),
//                           ),
//                         ),
//                         SizedBox(width: 20.0),
//                       ],
//                     ),
//                   ],
//                 ),
//               );
//             }
//             return SizedBox();
//           },
//         ),
//       ),
//     );
//   }
// }
