import 'package:flutter/material.dart';
import 'package:road24_mobile/data/response/FinesResponse.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/utils/extensions.dart';
import 'package:sizer/sizer.dart';
import 'package:translit/translit.dart';
import 'package:intl/intl.dart';

import 'package:road24_mobile/utils/frequent_widgets.dart';

class PaymentHistory extends StatelessWidget {
  final List<Pays> paidFines;

  const PaymentHistory({Key? key, required this.paidFines}) : super(key: key);

  String humanizeCost(String sum) {
    if (sum.endsWith('.0')) {
      sum = sum + '0';
    }
    List<String> sumBuffer = sum.split('.');
    String refactoredSumFormat =
        FrequentWidgets.intComma(int.parse(sumBuffer[0])).replaceAll(',', ' ') +
            '.' +
            sumBuffer[1].toString();
    refactoredSumFormat = refactoredSumFormat.replaceAll(".00", "");
    return refactoredSumFormat;
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.appPrimaryColor,
      appBar: AppBar(
        leading: FrequentWidgets.appBarBackButton(context),
        title: Text(S.of(context).payment_history,
            style: AppStyle.textStyle().copyWith(
                color: Colors.black,
                fontSize: 17.0,
                fontWeight: FontWeight.w600)),
      ),
      body: ListView(
        shrinkWrap: true,
        children: List.generate(
          paidFines.length,
          (index) => Container(
            padding: const EdgeInsets.symmetric(horizontal: 15.0),
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(
                      (Config.language == "oz")
                          ? Translit()
                              .unTranslit(
                                  source: DateFormat('dd MMM yyyy, HH:mm', 'uz')
                                      .format(DateTime.parse(
                                              paidFines[index].createdDate!)
                                          .toLocal()))
                              .toString()
                              .monthReplacement()
                          : DateFormat('dd MMM yyyy, HH:mm', Config.language)
                              .format(
                                  DateTime.parse(paidFines[index].createdDate!)
                                      .toLocal())
                              .toString(),
                      style: AppStyle.textStyle().copyWith(
                          color: Color(0xff747474),
                          fontWeight: FontWeight.w400,
                          fontSize: 15.0),
                    ),
                    Text(
                      '${humanizeCost(paidFines[index].pAmount!)} ${S.of(context).uzs.toLowerCase()}',
                      style: AppStyle.textStyle()
                          .copyWith(color: Colors.black, fontSize: 16.0),
                    ),
                  ],
                ),
                Container(
                  margin: EdgeInsets.symmetric(vertical: 2.0.w),
                  width: 90.0.w,
                  height: 1.0,
                  color: AppColors.colorcacaca,
                )
              ],
            ),
          ),
        ),
      ),
    );
  }
}
