import 'dart:ui';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:flutter/widgets.dart';
import 'package:rate_my_app/rate_my_app.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/base/splash/splash_screen.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/widgets/custom_button.dart';

//This page is not active current moment, It is not being used anywhere in the app
class PaySuccessPage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    SizedBox _size = SizedBox(
      width: 20.0,
    );
    return RateMyAppBuilder(
      rateMyApp: SplashScreen.rateMyApp,
      onInitialized: (context, rateMyApp) {
        try {
          rateMyApp.conditions.forEach((condition) {
            if (condition is DebuggableCondition) {
              print(condition
                  .valuesAsString); // We iterate through our list of conditions and we print all debuggable ones.
            }
          });
          print('Are all conditions met ? ' +
              (rateMyApp.shouldOpenDialog ? 'Yes' : 'No'));
          if (rateMyApp.shouldOpenDialog) {
            rateMyApp.showRateDialog(context,
                title: S.of(context).rate_title,
                message: S.of(context).rate_message,
                rateButton: S.of(context).rate_button,
                noButton: S.of(context).rate_no_button,
                laterButton: S.of(context).rate_later_button,
                dialogStyle: DialogStyle(
                  titleStyle: AppStyle.textStyle().copyWith(
                    color: Color(0xff282828),
                    fontSize: 18.0,
                    fontWeight: FontWeight.w600,
                  ),
                  messageStyle: AppStyle.textStyle().copyWith(
                    color: Color(0xff282828),
                    fontSize: 16.0,
                    fontWeight: FontWeight.w400,
                  ),
                ));
          }
        } catch (e) {}
      },
      builder: (context) => Scaffold(
        backgroundColor: Color(0xffF9F9F9),
        body: ListView(
          children: [
            SizedBox(height: kToolbarHeight),
            Row(
              children: [
                Image.asset("assets/png/thumb_up_success.png"),
              ],
            ),
            Row(
              children: [
                _size,
                Expanded(
                  child: Text(
                    "Вы успешно оплатили штраф №009786!",
                    style: AppStyle.textStyle().copyWith(
                      color: Color(0xff282828),
                      fontSize: 24.0,
                      fontWeight: FontWeight.bold,
                    ),
                    maxLines: 2,
                    overflow: TextOverflow.ellipsis,
                  ),
                ),
                _size,
              ],
            ),
            SizedBox(height: 10.0),
            Row(
              children: [
                _size,
                Expanded(
                  child: Text(
                    S.of(context).success_payment,
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff747474),
                        fontWeight: FontWeight.normal,
                        fontSize: 15.0),
                  ),
                ),
                _size,
              ],
            ),
            SizedBox(height: 20.0),
            Row(
              children: [
                _size,
                Expanded(
                  child: CustomButton(
                    color: Color(0xffDCDCDC),
                    onTap: () {
                      Navigator.pop(context);
                    },
                    title: "${S.of(context).ok}",
                    textStyle: AppStyle.textStyle().copyWith(
                        color: Color(0xff333333),
                        fontWeight: FontWeight.w600,
                        fontSize: 16.0),
                  ),
                ),
                _size,
              ],
            ),
            SizedBox(height: 20.0),
          ],
        ),
      ),
    );
  }
}
