import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:flutter_html/style.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/utils/frequent_widgets.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class FineMustPage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Color(0xffF9F9F9),
      appBar: _AppBar(titleText: S.of(context).my_car),
      body: _Body(data: S.of(context).fines_must_text),
      bottomSheet: _BottomSheet(),
    );
  }
}

class _AppBar extends StatelessWidget implements PreferredSizeWidget {
  final String? titleText;

  const _AppBar({this.titleText});

  @override
  Widget build(BuildContext context) {
    return AppBar(
      toolbarHeight: 60.0,
      leading: FrequentWidgets.appBarBackButton(context),
      title: Text(
        "$titleText",
        style: AppStyle.textStyle().copyWith(
            color: Colors.black, fontWeight: FontWeight.w600, fontSize: 17.0),
      ),
    );
  }

  @override
  Size get preferredSize => Size.fromHeight(kToolbarHeight);
}

class _Body extends StatelessWidget {
  final String? data;

  const _Body({this.data});

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      physics: BouncingScrollPhysics(),
      child: Container(
        width: double.infinity,
        margin: EdgeInsets.only(left: 12, right: 12, top: 16, bottom: 130),
        padding: EdgeInsets.symmetric(horizontal: 12, vertical: 6),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(16),
        ),
        child: Html(
          data: data,
          shrinkWrap: true,
          style: {
            'h1': Style(
              fontSize: FontSize(20),
              fontWeight: FontWeight.w700,
              fontFamily: 'SF Pro',
              color: AppColors.colorf51a51,
            ),
            'h2': Style(
              fontSize: FontSize(16),
              fontWeight: FontWeight.w400,
              fontFamily: 'SF Pro',
            ),
            'span': Style(
              fontSize: FontSize(16),
              fontWeight: FontWeight.w400,
              color: AppColors.colorf51a51,
              fontFamily: 'SF Pro',
            ),
          },
        ),
      ),
    );
  }
}

class _BottomSheet extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      height: 100,
      alignment: Alignment.bottomCenter,
      padding: EdgeInsets.only(bottom: 30),
      child: GestureDetector(
        onTap: () => Navigator.pop(context),
        child: Container(
          width: double.infinity,
          height: 60,
          margin: EdgeInsets.symmetric(horizontal: 16),
          padding: EdgeInsets.symmetric(vertical: 18),
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: AppColors.selectedColor,
            borderRadius: BorderRadius.circular(12),
          ),
          child: Text(
            S.of(context).back,
            style: AppStyle.textStyle().copyWith(
              color: Colors.white,
              fontSize: 16,
              fontWeight: FontWeight.w600,
            ),
          ),
        ),
      ),
    );
  }
}
