import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class CarsAddItem extends StatelessWidget {
  final GestureTapCallback? onTap;
  final EdgeInsetsGeometry? margin;

  const CarsAddItem({this.onTap, this.margin});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      onTap: onTap,
      child: Container(
        height: 210,
        margin: margin,
        alignment: Alignment.center,
        padding: EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(12.0),
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Text(
              S.of(context).add_car,
              style: AppStyle.textStyle().copyWith(
                color: AppColors.selectedColor,
                fontSize: 18,
              ),
            ),
            SizedBox(height: 5),
            Icon(
              CupertinoIcons.add_circled,
              color: AppColors.selectedColor,
              size: 30,
            ),
          ],
        ),
      ),
    );
  }
}
