part of 'cars_list_bloc.dart';

abstract class CarsListState extends Equatable {
  const CarsListState();
}

class CarsListInitialState extends CarsListState {
  final bool loading;
  final List<Results?> fullList;

  CarsListInitialState(this.loading, this.fullList);

  @override
  List<Object> get props => [loading, fullList];
}

class CarRefreshSuccessState extends CarsListState {
  final List<Results?> carList;

  CarRefreshSuccessState(this.carList);

  @override
  List<Object?> get props => [carList];
}

class CarLoadingState extends CarsListState {
  @override
  List<Object?> get props => [];
}
