part of 'cars_list_bloc.dart';

abstract class CarsListEvent extends Equatable {
  const CarsListEvent();
}

class CarsChangedListEvent extends CarsListEvent {
  final List<Results?> fullList;
  final BuildContext context;

  CarsChangedListEvent({required this.fullList, required this.context});

  @override
  List<Object?> get props => [fullList, context];
}

class CarsPinnedEvent extends CarsListEvent {
  final int carId;
  final bool pinned;
  final BuildContext context;

  CarsPinnedEvent(
      {required this.carId, required this.pinned, required this.context});

  @override
  List<Object?> get props => [carId, pinned, context];
}

class CarsRefreshEvent extends CarsListEvent {
  @override
  List<Object?> get props => [];
}
