import 'dart:io';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:dotted_border/dotted_border.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';

class SelectPhotoWidget extends StatelessWidget {
  final String? imageUrl;
  final File? imageFile;
  final VoidCallback? onEditPressed;
  final VoidCallback? onDeletePressed;
  final double ratioX;
  final double ratioY;

  const SelectPhotoWidget({
    required this.imageUrl,
    required this.imageFile,
    this.onEditPressed,
    this.onDeletePressed,
    this.ratioX = 4,
    this.ratioY = 3,
  });

  @override
  Widget build(BuildContext context) {
    final width = MediaQuery.of(context).size.width;
    final height = width * ratioY / ratioX;
    if (imageFile != null)
      return ClipRRect(
        borderRadius: BorderRadius.circular(12),
        child: Stack(
          children: [
            Image.file(
              imageFile!,
              width: width,
              height: height,
              fit: BoxFit.fill,
            ),
            Row(
              children: [
                Spacer(),
                MaterialButton(
                  minWidth: 40,
                  height: 40,
                  padding: EdgeInsets.all(0),
                  shape: CircleBorder(),
                  color: AppColors.appPrimaryColor.withOpacity(0.5),
                  disabledColor: AppColors.appPrimaryColor.withOpacity(0.5),
                  child: Icon(Icons.edit_outlined, color: Color(0xff282828)),
                  onPressed: onEditPressed,
                ),
                MaterialButton(
                  minWidth: 40,
                  height: 40,
                  padding: EdgeInsets.all(0),
                  shape: CircleBorder(),
                  color: AppColors.appPrimaryColor.withOpacity(0.5),
                  disabledColor: AppColors.appPrimaryColor.withOpacity(0.5),
                  child: Icon(
                    CupertinoIcons.delete,
                    color: AppColors.colorf51a51,
                  ),
                  onPressed: onDeletePressed,
                ),
              ],
            ),
          ],
        ),
      );
    if (imageUrl == null)
      return GestureDetector(
        onTap: onEditPressed,
        child: DottedBorder(
          borderType: BorderType.RRect,
          dashPattern: [10],
          radius: Radius.circular(16),
          strokeWidth: 2,
          color: AppColors.colorcacaca,
          child: Container(
            width: width,
            height: height,
            alignment: Alignment.center,
            child: SvgPicture.asset(
              'assets/svg/photo.svg',
              width: 50,
              color: AppColors.colorcacaca,
            ),
          ),
        ),
      );
    return ClipRRect(
      borderRadius: BorderRadius.circular(12),
      child: Stack(
        children: [
          CachedNetworkImage(
            imageUrl: imageUrl!,
            width: width,
            height: height,
            fit: BoxFit.fill,
          ),
          Row(
            children: [
              Spacer(),
              MaterialButton(
                minWidth: 40,
                height: 40,
                padding: EdgeInsets.all(0),
                shape: CircleBorder(),
                color: AppColors.appPrimaryColor.withOpacity(0.5),
                disabledColor: AppColors.appPrimaryColor.withOpacity(0.5),
                child: Icon(Icons.edit_outlined, color: Color(0xff282828)),
                onPressed: onEditPressed,
              ),
              MaterialButton(
                minWidth: 40,
                height: 40,
                padding: EdgeInsets.all(0),
                shape: CircleBorder(),
                color: AppColors.appPrimaryColor.withOpacity(0.5),
                disabledColor: AppColors.appPrimaryColor.withOpacity(0.5),
                child: Icon(
                  CupertinoIcons.delete,
                  color: AppColors.colorf51a51,
                ),
                onPressed: onDeletePressed,
              ),
            ],
          ),
        ],
      ),
    );
  }
}
