import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class SelectModelWidget extends StatelessWidget {
  final TextEditingController controller;
  final GestureTapCallback? onTap;
  final String? hintText;

  const SelectModelWidget({
    required this.controller,
    this.onTap,
    this.hintText,
  });

  @override
  Widget build(BuildContext context) {
    return TextFormField(
      cursorColor: AppColors.selectedColor,
      maxLines: 1,
      readOnly: true,
      onTap: onTap,
      controller: controller,
      style: AppStyle.textStyle().copyWith(
        color: Color(0xff282828),
        fontSize: 17.0,
        fontWeight: FontWeight.normal,
      ),
      decoration: InputDecoration(
        hintText: hintText,
        hintStyle: AppStyle.textStyle().copyWith(
          color: AppColors.unSelectedColor,
          fontSize: 17.0,
          fontWeight: FontWeight.normal,
        ),
        suffixIcon: Icon(
          Icons.keyboard_arrow_down,
          color: Colors.black,
        ),
        border: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.transparent),
        ),
        enabledBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Color(0xFFE0E0E0), width: 1.0),
        ),
        fillColor: Color(0xffEFEFEF),
        filled: true,
        focusedBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.black, width: 1.5),
        ),
        contentPadding: EdgeInsets.all(15.0),
      ),
      validator: (value) {
        if (value!.isEmpty) {
          return S.of(context).validationForEmpty;
        } else {
          return null;
        }
      },
    );
  }
}
