import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:shimmer/shimmer.dart';
import 'package:substring_highlight/substring_highlight.dart';

class SelectBrandItem extends StatelessWidget {
  final bool isLoading;
  final String? imageUrl;
  final String text;
  final String term;
  final VoidCallback? onPressed;

  const SelectBrandItem({
    this.isLoading = true,
    this.imageUrl,
    this.text = '',
    this.term = '',
    this.onPressed,
  });

  @override
  Widget build(BuildContext context) {
    if (isLoading) return _widgetLoading();
    return _widgetMainItem();
  }

  Widget _widgetLoading() {
    return Shimmer(
      gradient: const LinearGradient(
        begin: Alignment.centerRight,
        end: Alignment.centerLeft,
        colors: [
          Color.fromRGBO(231, 235, 240, 1),
          Color.fromRGBO(231, 235, 240, 1),
          Color.fromRGBO(251, 251, 251, 0.8),
          Color.fromRGBO(231, 235, 240, 1),
          Color.fromRGBO(231, 235, 240, 1),
        ],
        stops: <double>[0, 0.35, 0.5, 0.65, 2],
      ),
      period: const Duration(seconds: 2),
      direction: ShimmerDirection.ltr,
      child: Container(
        width: double.infinity,
        height: 40,
        padding: const EdgeInsets.symmetric(horizontal: 12),
        decoration: BoxDecoration(
          color: Colors.grey,
          borderRadius: BorderRadius.circular(6),
        ),
      ),
    );
  }

  Widget _widgetMainItem() {
    return GestureDetector(
      onTap: onPressed,
      child: Container(
        width: double.infinity,
        padding: const EdgeInsets.symmetric(vertical: 4),
        decoration: BoxDecoration(
          color: Colors.transparent,
          borderRadius: BorderRadius.circular(6),
        ),
        child: Row(
          children: [
            ClipRRect(
              borderRadius: BorderRadius.circular(12),
              child: _widgetImage(imageUrl),
            ),
            const SizedBox(width: 8),
            Expanded(
              child: SubstringHighlight(
                text: text,
                term: term,
                textStyle: AppStyle.textStyle().copyWith(
                  color: Color(0xff282828),
                  fontSize: 16,
                  fontWeight: FontWeight.w500,
                ),
                textStyleHighlight: AppStyle.textStyle().copyWith(
                  color: Color(0xff5556E8),
                  fontSize: 16,
                  fontWeight: FontWeight.w500,
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget _widgetImage(String? imageUrl) {
    if (imageUrl != null)
      return CachedNetworkImage(
        imageUrl: imageUrl,
        width: 40,
        height: 40,
        fit: BoxFit.fill,
        progressIndicatorBuilder: (context, url, progress) {
          return Shimmer(
            gradient: const LinearGradient(
              begin: Alignment.centerRight,
              end: Alignment.centerLeft,
              colors: [
                Color.fromRGBO(231, 235, 240, 1),
                Color.fromRGBO(231, 235, 240, 1),
                Color.fromRGBO(251, 251, 251, 0.8),
                Color.fromRGBO(231, 235, 240, 1),
                Color.fromRGBO(231, 235, 240, 1),
              ],
              stops: <double>[0, 0.35, 0.5, 0.65, 2],
            ),
            period: const Duration(seconds: 2),
            direction: ShimmerDirection.ltr,
            child: Container(width: 40, height: 40),
          );
        },
        errorWidget: (context, url, error) {
          return Image.asset(
            "assets/brand/placeholder.jpeg",
            width: 40,
            height: 40,
            fit: BoxFit.fill,
          );
        },
      );
    return Image.asset(
      "assets/brand/images/${text.toLowerCase()}.png",
      width: 40,
      height: 40,
      fit: BoxFit.fill,
      errorBuilder: (context, error, stackTrace) {
        return Image.asset(
          "assets/brand/placeholder.jpeg",
          width: 40,
          height: 40,
          fit: BoxFit.fill,
        );
      },
    );
  }
}
