import 'package:flutter/material.dart';
import 'package:modal_bottom_sheet/modal_bottom_sheet.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/widgets/text_field_custom_formatter.dart';
import '../select_brand_dialog.dart';

class OtherDialog extends StatelessWidget {
  static Future<void> show(
    BuildContext context, {
    String title = "",
    String text = "",
    required SelectBrandImp imp,
  }) async {
    await showBarModalBottomSheet(
      context: context,
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(20),
          topRight: Radius.circular(20),
        ),
      ),
      builder: (_) => OtherDialog._(
        title,
        imp,
        TextEditingController(text: text),
      ),
    );
  }

  final String title;
  final SelectBrandImp imp;
  final TextEditingController controller;

  OtherDialog._(this.title, this.imp, this.controller);

  @override
  Widget build(BuildContext context) {
    return Container(
      height: MediaQuery.of(context).size.height * 0.75,
      padding: const EdgeInsets.only(left: 20, right: 20, top: 20),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title,
            style: AppStyle.textStyle().copyWith(
              color: Colors.black,
              fontSize: 17,
              fontWeight: FontWeight.w600,
            ),
          ),
          const SizedBox(height: 10),
          TextFormField(
            cursorColor: AppColors.selectedColor,
            maxLines: 1,
            inputFormatters: [CustomTextInputFormatter(30)],
            keyboardType: TextInputType.text,
            textCapitalization: TextCapitalization.sentences,
            controller: controller,
            textAlign: TextAlign.left,
            style: AppStyle.textStyle().copyWith(
              color: Color(0xff282828),
              fontSize: 17.0,
              fontWeight: FontWeight.normal,
            ),
            decoration: InputDecoration(
              hintText: title,
              hintStyle: AppStyle.textStyle().copyWith(
                color: AppColors.unSelectedColor,
                fontSize: 17.0,
                fontWeight: FontWeight.normal,
              ),
              border: OutlineInputBorder(
                borderRadius: BorderRadius.circular(12.0),
                borderSide: BorderSide(color: Colors.transparent),
              ),
              enabledBorder: OutlineInputBorder(
                borderRadius: BorderRadius.circular(12.0),
                borderSide: BorderSide(color: Color(0xFFE0E0E0), width: 1.0),
              ),
              fillColor: Color(0xffEFEFEF),
              filled: true,
              focusedBorder: OutlineInputBorder(
                borderRadius: BorderRadius.circular(12.0),
                borderSide: BorderSide(color: Colors.black, width: 1.5),
              ),
              contentPadding: EdgeInsets.all(15.0),
            ),
            validator: (value) {
              if (value!.isEmpty) {
                return S.of(context).validationForEmpty;
              } else {
                return null;
              }
            },
          ),
          const SizedBox(height: 10),
          GestureDetector(
            onTap: () {
              imp.onUpdateBrand(brandName: controller.text);
              Navigator.pop(context);
            },
            child: Container(
              width: double.infinity,
              height: 50,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                color: AppColors.selectedColor,
                borderRadius: BorderRadius.circular(12),
              ),
              child: Text(
                S.of(context).add,
                style: AppStyle.textStyle().copyWith(
                  color: Color(0xffFAFAFA),
                  fontSize: 17,
                  fontWeight: FontWeight.w600,
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
