// import 'package:auto_size_text/auto_size_text.dart';
// import 'package:flutter/cupertino.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:road24_mobile/data/repository/CarsRepository.dart';
// import 'package:road24_mobile/data/response/CarsResponse.dart';
// import 'package:road24_mobile/model/blocs/mycar/cars_bloc.dart';
// import 'package:road24_mobile/model/utils/styles/AppColors.dart';
// import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
// import 'package:road24_mobile/utils/frequent_widgets.dart';
// import 'package:road24_mobile/view/built/i18n.dart';
// import 'package:road24_mobile/utils/extensions.dart';
// import 'package:road24_mobile/view/widgets/items/car_number.dart';

// import '../../my_car_page.dart';
// import '../oil_page_new.dart';

// class OilListPage extends StatefulWidget {
//   final int carDetailId;

//   const OilListPage({Key? key, required this.carDetailId}) : super(key: key);
//   @override
//   _OilListPageState createState() => _OilListPageState();
// }

// class _OilListPageState extends State<OilListPage> {
//   var carBloc = CarsBloc(repository: CarsRepository());
//   @override
//   void dispose() {
//     carBloc.close();
//     super.dispose();
//   }

//   @override
//   void initState() {
//     super.initState();
//     carBloc.add(GetCarOilList(carDetailId: widget.carDetailId));
//   }

//   @override
//   Widget build(BuildContext context) {
//     return Scaffold(
//         backgroundColor: AppColors.appPrimaryColor,
//         appBar: AppBar(
//           leading: FrequentWidgets.appBarBackButton(context),
//           title:
//               CarNumber(carNumber: MyCarPage.currentCarNumber!, fontSize: 18.0),
//           bottom: PreferredSize(
//             preferredSize: Size.fromHeight(30.0),
//             child: Container(
//               alignment: Alignment.centerLeft,
//               margin: EdgeInsets.symmetric(horizontal: 16.0),
//               child: Text(
//                 "${S.of(context).oil}",
//                 style: AppStyle.textStyle().copyWith(
//                     color: Color(0xff282828),
//                     fontWeight: FontWeight.w700,
//                     fontSize: 24.0),
//                 textAlign: TextAlign.left,
//                 maxLines: 1,
//                 overflow: TextOverflow.ellipsis,
//               ),
//             ),
//           ),
//         ),
//         body: BlocBuilder(
//             bloc: carBloc,
//             builder: (context, state) {
//               if (state is CarsInitial) {
//                 return Center(
//                   child: CircularProgressIndicator(),
//                 );
//               }
//               if (state is OilListResult) {
//                 var oilList = state.oilList;
//                 return Padding(
//                   padding: const EdgeInsets.fromLTRB(16, 16, 16, 0),
//                   child: Stack(
//                     children: [
//                       SingleChildScrollView(
//                         child: Column(
//                           mainAxisAlignment: MainAxisAlignment.start,
//                           crossAxisAlignment: CrossAxisAlignment.start,
//                           children: [
//                             Text(
//                               S.of(context).active.toUpperCase(),
//                               style: AppStyle.textStyle().copyWith(
//                                   fontWeight: FontWeight.w600,
//                                   color: Color(0xff282828),
//                                   fontSize: 16),
//                             ),
//                             SizedBox(height: 8.0),
//                             _oilListItem(oilList[0],
//                                 // Oil(
//                                 //     id: 1,
//                                 //     mileage: 100000,
//                                 //     lastReplacement: "2021-09-21",
//                                 //     nextReplacement: "2021-12-21",
//                                 //     car: 123,
//                                 //     chargePrice: 350000,
//                                 //     mark: 'Castrol',
//                                 //     nextMileage: 156000),
//                                 isActive: true),
//                             SizedBox(height: 20.0),
//                             Text(
//                               S.of(context).history.toUpperCase(),
//                               style: AppStyle.textStyle().copyWith(
//                                   fontWeight: FontWeight.w600,
//                                   color: Color(0xff282828),
//                                   fontSize: 16),
//                             ),
//                             SizedBox(height: 8.0),
//                             if (state is OilListResult)
//                               ListView.builder(
//                                   physics: NeverScrollableScrollPhysics(),
//                                   itemCount: oilList.length - 1,
//                                   padding: EdgeInsets.only(bottom: 86),
//                                   shrinkWrap: true,
//                                   itemBuilder: (context, index) {
//                                     return Padding(
//                                         padding: EdgeInsets.only(bottom: 16.0),
//                                         child: _oilListItem(oilList[index + 1]
//                                             // Oil(
//                                             //   id: 1,
//                                             //   mileage: 80000,
//                                             //   lastReplacement: "2021-07-21",
//                                             //   nextReplacement: "2021-11-18",
//                                             //   car: 123,
//                                             //   chargePrice: 150000,
//                                             //   mark: 'GM',
//                                             //   nextMileage: 125000)
//                                             ));
//                                   })
//                           ],
//                         ),
//                       ),
//                       _addButton()
//                     ],
//                   ),
//                 );
//               }
//               return Center(
//                 child: CircularProgressIndicator(),
//               );
//             }));
//   }

//   _addButton() {
//     return Align(
//       alignment: Alignment.bottomCenter,
//       child: Container(
//         margin: EdgeInsets.only(bottom: 40.0),
//         width: 190.0,
//         height: 50.0,
//         alignment: Alignment.center,
//         decoration: BoxDecoration(
//           color: AppColors.color333333,
//           borderRadius: BorderRadius.circular(32.0),
//         ),
//         child: Material(
//           borderRadius: BorderRadius.circular(32.0),
//           type: MaterialType.transparency,
//           shadowColor: Colors.white.withOpacity(0.3),
//           child: InkWell(
//             borderRadius: BorderRadius.circular(32.0),
//             onTap: () {
//               Navigator.push(
//                   context, CupertinoPageRoute(builder: (_) => OilPage()));
//             },
//             child: Container(
//               padding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 15.0),
//               decoration: BoxDecoration(
//                 borderRadius: BorderRadius.circular(32.0),
//               ),
//               child: Row(
//                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                 children: [
//                   Icon(Icons.add_circle_outline,
//                       color: Colors.white, size: 22.0),
//                   Text(
//                     S.of(context).add_oil,
//                     style: AppStyle.textStyle().copyWith(
//                         color: Colors.white,
//                         fontWeight: FontWeight.w500,
//                         fontSize: 16.0),
//                     textAlign: TextAlign.left,
//                     maxLines: 1,
//                     overflow: TextOverflow.ellipsis,
//                   ),
//                   SizedBox(width: 5.0),
//                 ],
//               ),
//             ),
//           ),
//         ),
//       ),
//     );
//   }

//   _oilListItem(Oil oilModel, {bool isActive = false}) {
//     var nextDate = DateTime.parse(oilModel.nextReplacement);
//     var difference = nextDate.difference(DateTime.now());
//     return InkWell(
//       onTap: () {
//         Navigator.push(context,
//             CupertinoPageRoute(builder: (_) => OilPage(oil: oilModel)));
//       },
//       child: Container(
//         decoration: BoxDecoration(
//           borderRadius: BorderRadius.circular(12.0),
//           color: Colors.white,
//           boxShadow: [
//             BoxShadow(
//               color: Colors.black.withOpacity(0.12),
//               blurRadius: 6.0,
//               spreadRadius: 0,
//               offset: Offset(
//                 2.0,
//                 2.0,
//               ),
//             ),
//           ],
//         ),
//         padding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 16),
//         child: Column(
//           mainAxisAlignment: MainAxisAlignment.start,
//           crossAxisAlignment: CrossAxisAlignment.start,
//           children: [
//             Row(
//               mainAxisAlignment: MainAxisAlignment.spaceBetween,
//               children: [
//                 Text(oilModel.mark,
//                     style: AppStyle.textStyle().copyWith(
//                         fontWeight: FontWeight.w500,
//                         color: Color(0xff989898),
//                         fontSize: 15)),
//                 Text(
//                     "${FrequentWidgets.intComma(oilModel.chargePrice, decimalDigit: 0)} ${S.of(context).uzs.toLowerCase()}",
//                     style: AppStyle.textStyle().copyWith(
//                         fontWeight: FontWeight.w500,
//                         color: Color(0xff989898),
//                         fontSize: 15)),
//               ],
//             ),
//             SizedBox(height: 16.0),
//             Text(
//                 "${FrequentWidgets.intComma(oilModel.nextMileage, decimalDigit: 0)} ${S.of(context).km}",
//                 style: AppStyle.textStyle().copyWith(
//                     fontWeight: FontWeight.w600,
//                     color: Color(0xffF51A51),
//                     // color: Color(0xff282828),
//                     fontSize: 20)),
//             AutoSizeText(
//               isActive
//                   ? "${S.of(context).nDays(difference.inDays)}"
//                   : "${S.of(context).mileage}",
//               style: AppStyle.textStyle().copyWith(
//                   fontWeight: FontWeight.w400,
//                   color: Color(0xff282828),
//                   fontSize: 14),
//               maxLines: 1,
//               overflow: TextOverflow.ellipsis,
//             ),
//             if (isActive)
//               Column(
//                 children: [
//                   SizedBox(height: 4),
//                   ClipRRect(
//                     borderRadius: BorderRadius.circular(3),
//                     child: LinearProgressIndicator(
//                       backgroundColor: Color(0xFFE9E9E9),
//                       valueColor: AlwaysStoppedAnimation(
//                         difference.inDays <= 30
//                             ? AppColors.error
//                             : AppColors.indicatorColor,
//                       ),
//                       value: 0.87,
//                       // value: passedDays / totalDays,
//                       minHeight: 8.0,
//                     ),
//                   ),
//                 ],
//               ),
//             SizedBox(height: 16.0),
//             (isActive)
//                 ? Row(
//                     mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                     children: [
//                       Text(
//                           oilModel.lastReplacement
//                               .toFormatDate()!
//                               .monthReplacement(),
//                           style: AppStyle.textStyle().copyWith(
//                               fontWeight: FontWeight.w500,
//                               color: Color(0xff989898),
//                               fontSize: 15)),
//                       Text(
//                           oilModel.nextReplacement
//                               .toFormatDate()!
//                               .monthReplacement(),
//                           style: AppStyle.textStyle().copyWith(
//                               fontWeight: FontWeight.w500,
//                               color: Color(0xff989898),
//                               fontSize: 15)),
//                     ],
//                   )
//                 : Text(
//                     "${S.of(context).expired}:  ${oilModel.nextReplacement.toFormatDate()!}",
//                     style: AppStyle.textStyle().copyWith(
//                         fontWeight: FontWeight.w500,
//                         color: Color(0xff989898),
//                         fontSize: 15)),
//           ],
//         ),
//       ),
//     );
//   }
// }
