import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:modal_progress_hud_nsn/modal_progress_hud_nsn.dart';
import 'package:road24_mobile/data/repository/CarsRepository.dart';
import 'package:road24_mobile/data/response/CarsResponse.dart';
import 'package:road24_mobile/model/blocs/mycar/cars_bloc.dart';
import 'package:road24_mobile/model/models/AddCarModel.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/my_app.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/home/dash_board.dart';
import 'package:road24_mobile/view/mycar/my_car_page.dart';
import 'package:road24_mobile/view/widgets/custom_bottom_tabbar.dart';
import 'package:road24_mobile/view/widgets/fade_route.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import 'package:road24_mobile/view/widgets/success_page.dart';
import 'package:road24_mobile/view/widgets/text_field_custom_formatter.dart';
import 'package:road24_mobile/utils/extensions.dart';

import 'inspection/widgets/custom_appbar.dart';

class InsurancePage extends StatefulWidget {
  final Insurance? insurance;
  // static List<String>? kindVariations;

  const InsurancePage({Key? key, this.insurance}) : super(key: key);

  @override
  _InsurancePageState createState() => _InsurancePageState();
}

class _InsurancePageState extends State<InsurancePage> {
  bool loading = false;
  CarsBloc _carsBloc = CarsBloc(repository: CarsRepository());
  GlobalKey<FormState> _key = GlobalKey();
  late TextEditingController datePassedController;
  late TextEditingController dateEndController;
  String? kind;
  List<String> kindVariationsToSend = ['osago', 'kasko', 'other'];
  List<String> kindVariations = [];
  String? numberOfDrivers;
  List<String>? numberOfDriversVariations;
  String? companyName;
  List<String> companyNameVariations = [
    "O'ZBEKINVEST",
    "GROSS INSURANCE",
    "O'ZAGROSUG'URTA",
    "KAFOLAT SUG'URTA",
    "EUROASIA INSURANCE",
    "APEX INSURANCE",
    "MY INSURANCE",
    "ALFA INVEST",
    "TEMIRYO'L SUG'URTA",
    "ASIA INSURANSE",
    "KAFIL SUG'URTA",
    "KAPITAL SUG’URTA",
    "PSB INSURANCE",
    "ALSKOM",
    "INGO-UZBEKISTAN",
    "ASKO-VOSTOK",
    "IMKON-SUG'URTA",
    "XALQ SUG’URTA",
    "UNIVERSAL-SUG'URTA",
    "HAMKOR SUG’URTA",
    "INSON",
    "ISHONCH",
    "OMAD SUG'URTA",
    "GARANT INSURANCE GROUP",
    "DD-GENERAL INSURANCE",
    "GLOBAL INSURANCE GROUP",
    "PERFECT INSURANCE",
    "UNIPOLIS",
    "ARIA SUG'URTA",
    "SEMURG INSURANCE",
    "SHARQ-SUG'URTA",
    "TRUST-INSURANCE"
  ];
  late TextEditingController seriesController;
  late TextEditingController numberController;
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();

  @override
  void initState() {
    if (widget.insurance != null) {
      var insurance = widget.insurance!;
      seriesController = TextEditingController(text: insurance.series);
      numberController = TextEditingController(text: insurance.number);
      datePassedController = TextEditingController(
          text: DateTime.parse(insurance.datePassed).dateToStr());

      dateEndController = TextEditingController(
          text: DateTime.parse(insurance.dateEnd).dateToStr());

      companyName = insurance.companyName;
      print(companyName);
      numberOfDrivers = insurance.numberOfDrivers.toString();
      print(dateEndController.text);
      AddInsuranceModel.kind = insurance.kind;
      AddInsuranceModel.series = seriesController.text;
      AddInsuranceModel.number = numberController.text;
      AddInsuranceModel.companyName = insurance.companyName;
      AddInsuranceModel.datePassed =
          DateFormat('yyyy-MM-dd').format(DateTime.parse(insurance.datePassed));
      AddInsuranceModel.dateEnd =
          DateFormat('yyyy-MM-dd').format(DateTime.parse(insurance.dateEnd));
    } else {
      seriesController = TextEditingController();
      numberController = TextEditingController();
      datePassedController = TextEditingController();
      dateEndController = TextEditingController();
    }
    super.initState();
  }

  @override
  void dispose() {
    // InsurancePage.kindVariations = null;
    numberOfDriversVariations = null;
    datePassedController.dispose();
    dateEndController.dispose();
    seriesController.dispose();
    numberController.dispose();
    AddInsuranceModel.companyName = '';
    AddInsuranceModel.dateEnd = '';
    AddInsuranceModel.datePassed = '';
    AddInsuranceModel.numberOfDrivers = null;
    AddInsuranceModel.kind = '';
    AddInsuranceModel.series = '';
    AddInsuranceModel.number = '';
    _carsBloc.close();
    super.dispose();
  }

  void init(context) {
    // if (InsurancePage.kindVariations == null) {
    //   InsurancePage.kindVariations=
    //       [S.of(context).kasko, S.of(context).osago, S.of(context).other];
    // }

    kindVariations.addAll(
        [S.of(context).osago, S.of(context).kasko, S.of(context).other]);

    if (numberOfDriversVariations == null) {
      numberOfDriversVariations = [
        '1',
        '2',
        '3',
        '4',
        '5',
        S.of(context).unlimited,
      ];
    }
    if (kind == null) {
      if (widget.insurance == null) {
        numberOfDrivers = numberOfDriversVariations![0];
        AddInsuranceModel.numberOfDrivers = 1;
        kind = kindVariations[0];
        companyName = companyNameVariations[0];
        AddInsuranceModel.kind =
            kindVariationsToSend[kindVariations.indexOf(kind!)];
        AddInsuranceModel.companyName = companyName!;
      } else {
        numberOfDrivers = widget.insurance!.numberOfDrivers.toString();
        print(numberOfDrivers);
        if (numberOfDrivers == '8') {
          numberOfDrivers = numberOfDriversVariations!.last;
        }
        kind = kindVariations[
            kindVariationsToSend.indexOf(widget.insurance!.kind)];
      }
    }
  }

  bool isBuilt = false;
  @override
  Widget build(BuildContext context) {
    if (!isBuilt) {
      init(context);
      setState(() => isBuilt = true);
    }
    return ValueListenableBuilder(
        valueListenable: MyApp.hasInternet,
        builder: (context, bool hasInternet, _) {
          return (hasInternet)
              ? ModalProgressHUD(
                  inAsyncCall: loading,
                  color: AppColors.unSelectedColor,
                  progressIndicator: CircularProgressIndicator(
                    strokeWidth: 3.0,
                    valueColor: AlwaysStoppedAnimation<Color>(
                      AppColors.unSelectedColor,
                    ),
                  ),
                  child: GestureDetector(
                    onTap: () {
                      FocusScope.of(context).requestFocus(new FocusNode());
                    },
                    child: Scaffold(
                        appBar:
                            CustomAppBar(titleText: S.of(context).insurance),
                        body: BlocListener(
                          listener: (context, state) {
                            if (state is EditCarSuccessState) {
                              setState(() {
                                loading = false;
                              });
                              Navigator.pushReplacement(
                                context,
                                CupertinoPageRoute(
                                  builder: (context) => SuccessPage(
                                    text: S.of(context).success,
                                    subText: S.of(context).edit_car_success_ins,
                                    onTap: () {
                                      DashBoard.activeTab.value =
                                          CustomBottomTabBar
                                              .indexMap['MyAvto']!;
                                      Navigator.pop(context);
                                      MyCarPage.needToRefresh.value = true;
                                    },
                                    // onTapSkip: () {},
                                  ),
                                ),
                              );
                            }
                            if (state is CarsLoadingError) {
                              setState(() {
                                loading = false;
                              });
                            }
                          },
                          bloc: _carsBloc,
                          child: BlocBuilder(
                            bloc: _carsBloc,
                            builder: (context, state) {
                              return Form(
                                key: _key,
                                child: Column(
                                  children: [
                                    Expanded(
                                      child: ListView(
                                        padding: EdgeInsets.symmetric(
                                            horizontal: 15.0),
                                        children: [
                                          SizedBox(height: 20.0),
                                          Text(
                                            "${S.of(context).validity}",
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xFF959595),
                                                    fontSize: 15.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                          Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Container(
                                                  margin: EdgeInsets.symmetric(
                                                      vertical: 4.0),
                                                  child: InkWell(
                                                    onTap: () {
                                                      showDatePicker(
                                                        context: context,
                                                        initialDate:
                                                            DateTime.now(),
                                                        firstDate: DateTime(
                                                            DateTime.now()
                                                                    .year -
                                                                20),
                                                        lastDate:
                                                            DateTime.now(),
                                                        locale: Locale((Config
                                                                    .language !=
                                                                'oz')
                                                            ? Config.language
                                                            : 'uz'),
                                                      ).then(
                                                        (value) => {
                                                          this.setState(() {
                                                            try {
                                                              AddInsuranceModel
                                                                      .datePassed =
                                                                  DateFormat(
                                                                          'yyyy-MM-dd')
                                                                      .format(
                                                                          value!);
                                                              print(value);
                                                              datePassedController
                                                                      .text =
                                                                  value
                                                                      .dateToStr();
                                                            } catch (_) {}
                                                          }),
                                                        },
                                                      );
                                                    },
                                                    child: IgnorePointer(
                                                      ignoring: true,
                                                      child: TextFormField(
                                                        cursorColor: AppColors
                                                            .selectedColor,
                                                        controller:
                                                            datePassedController,
                                                        keyboardType:
                                                            TextInputType.text,
                                                        decoration:
                                                            InputDecoration(
                                                          hintText: 'дд.мм.гг',
                                                          hintStyle: AppStyle
                                                                  .textStyle()
                                                              .copyWith(
                                                            color: AppColors
                                                                .unSelectedColor,
                                                            fontSize: 17.0,
                                                            fontWeight:
                                                                FontWeight
                                                                    .normal,
                                                          ),
                                                          border:
                                                              OutlineInputBorder(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        12.0),
                                                            borderSide: BorderSide(
                                                                color: Colors
                                                                    .transparent),
                                                          ),
                                                          enabledBorder:
                                                              OutlineInputBorder(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        12.0),
                                                            borderSide: BorderSide(
                                                                color: Colors
                                                                    .transparent),
                                                          ),
                                                          fillColor:
                                                              Color(0xffEFEFEF),
                                                          filled: true,
                                                          focusedBorder:
                                                              OutlineInputBorder(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        12.0),
                                                            borderSide:
                                                                BorderSide(
                                                                    color: Colors
                                                                        .black,
                                                                    width: 1.5),
                                                          ),
                                                          contentPadding:
                                                              EdgeInsets.all(
                                                                  15.0),
                                                          errorMaxLines: 2,
                                                        ),
                                                        validator: (value) {
                                                          if (value!.isEmpty) {
                                                            return S
                                                                .of(context)
                                                                .validationForEmpty;
                                                          } else {
                                                            return null;
                                                          }
                                                        },
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 15.0),
                                              Expanded(
                                                flex: 1,
                                                child: Container(
                                                  margin: EdgeInsets.symmetric(
                                                      vertical: 4.0),
                                                  child: InkWell(
                                                    onTap: () {
                                                      showDatePicker(
                                                        context: context,
                                                        initialDate:
                                                            DateTime.now(),
                                                        firstDate:
                                                            DateTime.now(),
                                                        lastDate: DateTime(
                                                            DateTime.now()
                                                                    .year +
                                                                10),
                                                        locale: Locale((Config
                                                                    .language !=
                                                                'oz')
                                                            ? Config.language
                                                            : 'uz'),
                                                      ).then(
                                                        (value) => {
                                                          this.setState(() {
                                                            try {
                                                              AddInsuranceModel
                                                                      .dateEnd =
                                                                  DateFormat(
                                                                          'yyyy-MM-dd')
                                                                      .format(
                                                                          value!);
                                                              print(value);
                                                              dateEndController
                                                                      .text =
                                                                  value
                                                                      .dateToStr();
                                                            } catch (_) {}
                                                          }),
                                                        },
                                                      );
                                                    },
                                                    child: IgnorePointer(
                                                      ignoring: true,
                                                      child: TextFormField(
                                                        cursorColor: AppColors
                                                            .selectedColor,
                                                        controller:
                                                            dateEndController,
                                                        keyboardType:
                                                            TextInputType.text,
                                                        decoration:
                                                            InputDecoration(
                                                          hintText: 'дд.мм.гг',
                                                          hintStyle: AppStyle
                                                                  .textStyle()
                                                              .copyWith(
                                                            color: AppColors
                                                                .unSelectedColor,
                                                            fontSize: 17.0,
                                                            fontWeight:
                                                                FontWeight
                                                                    .normal,
                                                          ),
                                                          border:
                                                              OutlineInputBorder(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        12.0),
                                                            borderSide: BorderSide(
                                                                color: Colors
                                                                    .transparent),
                                                          ),
                                                          enabledBorder:
                                                              OutlineInputBorder(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        12.0),
                                                            borderSide: BorderSide(
                                                                color: Colors
                                                                    .transparent),
                                                          ),
                                                          fillColor:
                                                              Color(0xffEFEFEF),
                                                          filled: true,
                                                          focusedBorder:
                                                              OutlineInputBorder(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        12.0),
                                                            borderSide:
                                                                BorderSide(
                                                                    color: Colors
                                                                        .black,
                                                                    width: 1.5),
                                                          ),
                                                          contentPadding:
                                                              EdgeInsets.all(
                                                                  15.0),
                                                          errorMaxLines: 2,
                                                        ),
                                                        validator: (value) {
                                                          if (value!.isEmpty) {
                                                            return S
                                                                .of(context)
                                                                .validationForEmpty;
                                                          } else {
                                                            return null;
                                                          }
                                                        },
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(height: 10.0),
                                          Text(
                                            "${S.of(context).insurance_type}",
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xFF959595),
                                                    fontSize: 15.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                          Container(
                                            height: 50.0,
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 15.0),
                                            margin: EdgeInsets.symmetric(
                                                vertical: 6.0),
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(12.0),
                                              color: Color(0xffEFEFEF),
                                            ),
                                            child: Center(
                                              child: DropdownButton(
                                                isExpanded: true,
                                                underline: SizedBox(),
                                                items: kindVariations
                                                    .map((String value) {
                                                  return DropdownMenuItem<
                                                      String>(
                                                    value: value,
                                                    child: Text(
                                                      value,
                                                      style:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                    ),
                                                  );
                                                }).toList(),
                                                onChanged: (String? value) {
                                                  setState(() {
                                                    kind = value!;
                                                    AddInsuranceModel.kind =
                                                        kindVariationsToSend[
                                                            kindVariations
                                                                .indexOf(
                                                                    kind!)];
                                                  });
                                                },
                                                hint: Text(
                                                  kind ??
                                                      '${S.of(context).choose}',
                                                  style: TextStyle(
                                                    fontSize: 17.0,
                                                    fontWeight: FontWeight.w300,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                          SizedBox(height: 10.0),
                                          Text(
                                            "${S.of(context).number_of_drivers}",
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xFF959595),
                                                    fontSize: 15.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                          Container(
                                            height: 50.0,
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 15.0),
                                            margin: EdgeInsets.symmetric(
                                                vertical: 6.0),
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(12.0),
                                              color: Color(0xffEFEFEF),
                                            ),
                                            child: Center(
                                              child: DropdownButton(
                                                isExpanded: true,
                                                underline: SizedBox(),
                                                value: numberOfDrivers,
                                                items:
                                                    numberOfDriversVariations!
                                                        .map((String value) {
                                                  return DropdownMenuItem(
                                                    value: value.toString(),
                                                    child: Text(
                                                      value.toString(),
                                                      style:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                    ),
                                                  );
                                                }).toList(),
                                                onChanged: (String? value) {
                                                  setState(() {
                                                    numberOfDrivers = value;
                                                    if (numberOfDrivers ==
                                                        S
                                                            .of(context)
                                                            .unlimited) {
                                                      AddInsuranceModel
                                                          .numberOfDrivers = 8;
                                                    } else {
                                                      AddInsuranceModel
                                                              .numberOfDrivers =
                                                          int.parse(
                                                              numberOfDrivers!);
                                                    }
                                                  });
                                                },
                                                hint: Text(
                                                  S.of(context).choose,
                                                  style: TextStyle(
                                                    fontSize: 17.0,
                                                    fontWeight: FontWeight.w300,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                          SizedBox(height: 10.0),
                                          Text(
                                            "${S.of(context).insurance_company}",
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Color(0xFF959595),
                                                    fontSize: 15.0,
                                                    fontWeight:
                                                        FontWeight.normal),
                                          ),
                                          Container(
                                            height: 50.0,
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 15.0),
                                            margin: EdgeInsets.symmetric(
                                                vertical: 6.0),
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(12.0),
                                              color: Color(0xffEFEFEF),
                                            ),
                                            child: Center(
                                              child: DropdownButton(
                                                isExpanded: true,
                                                value: companyName,
                                                underline: SizedBox(),
                                                items: companyNameVariations
                                                    .map((String value) {
                                                  return DropdownMenuItem<
                                                      String>(
                                                    value: value,
                                                    child: Text(
                                                      value,
                                                      style:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                    ),
                                                  );
                                                }).toList(),
                                                onChanged: (String? value) {
                                                  setState(() {
                                                    companyName = value!;
                                                    AddInsuranceModel
                                                            .companyName =
                                                        companyName!;
                                                  });
                                                },
                                                hint: Text(
                                                  companyName ??
                                                      '${S.of(context).choose}',
                                                  style: TextStyle(
                                                    fontSize: 17.0,
                                                    fontWeight: FontWeight.w300,
                                                  ),
                                                ),
                                                // style: TextStyle(
                                                //   color: Colors.red
                                                // ),
                                              ),
                                            ),
                                          ),
                                          SizedBox(height: 10.0),
                                          Row(
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Text(
                                                  "${S.of(context).series}",
                                                  style: AppStyle.textStyle()
                                                      .copyWith(
                                                          color:
                                                              Color(0xFF959595),
                                                          fontSize: 15.0,
                                                          fontWeight: FontWeight
                                                              .normal),
                                                ),
                                              ),
                                              SizedBox(width: 15.0),
                                              Expanded(
                                                flex: 2,
                                                child: Text(
                                                  "${S.of(context).number}",
                                                  style: AppStyle.textStyle()
                                                      .copyWith(
                                                          color:
                                                              Color(0xFF959595),
                                                          fontSize: 15.0,
                                                          fontWeight: FontWeight
                                                              .normal),
                                                ),
                                              ),
                                            ],
                                          ),
                                          Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Container(
                                                  margin: EdgeInsets.symmetric(
                                                      vertical: 4.0),
                                                  child: TextFormField(
                                                    cursorColor:
                                                        AppColors.selectedColor,
                                                    controller:
                                                        seriesController,
                                                    inputFormatters: [
                                                      CustomTextInputFormatter(
                                                          4),
                                                      FilteringTextInputFormatter
                                                          .allow(RegExp(
                                                              "[a-zA-Z]")),
                                                      UpperCaseTextFormatter(),
                                                    ],
                                                    keyboardType:
                                                        TextInputType.text,
                                                    decoration: InputDecoration(
                                                      hintText: 'AAAA',
                                                      hintStyle:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                      border:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors
                                                                .transparent),
                                                      ),
                                                      enabledBorder:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Color(
                                                                0xFFE0E0E0),
                                                            width: 1.0),
                                                      ),
                                                      fillColor:
                                                          Color(0xffEFEFEF),
                                                      filled: true,
                                                      focusedBorder:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors.black,
                                                            width: 1.5),
                                                      ),
                                                      contentPadding:
                                                          EdgeInsets.all(15.0),
                                                      errorMaxLines: 2,
                                                    ),
                                                    validator: (value) {
                                                      if (value!.length < 2) {
                                                        return S
                                                            .of(context)
                                                            .validationForEmpty;
                                                      } else {
                                                        return null;
                                                      }
                                                    },
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 15.0),
                                              Expanded(
                                                flex: 2,
                                                child: Container(
                                                  // height: 50.0,
                                                  margin: EdgeInsets.symmetric(
                                                      vertical: 4.0),
                                                  child: TextFormField(
                                                    cursorColor:
                                                        AppColors.selectedColor,
                                                    controller:
                                                        numberController,
                                                    inputFormatters: [
                                                      CustomTextInputFormatter(
                                                          13),
                                                      FilteringTextInputFormatter
                                                          .allow(
                                                              RegExp("[0-9]")),
                                                    ],
                                                    keyboardType:
                                                        TextInputType.number,
                                                    decoration: InputDecoration(
                                                      hintText: '0123456789012',
                                                      hintStyle:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color: AppColors
                                                            .unSelectedColor,
                                                        fontSize: 17.0,
                                                        fontWeight:
                                                            FontWeight.normal,
                                                      ),
                                                      border:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors
                                                                .transparent),
                                                      ),
                                                      enabledBorder:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Color(
                                                                0xFFE0E0E0),
                                                            width: 1.0),
                                                      ),
                                                      fillColor:
                                                          Color(0xffEFEFEF),
                                                      filled: true,
                                                      focusedBorder:
                                                          OutlineInputBorder(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(12.0),
                                                        borderSide: BorderSide(
                                                            color: Colors.black,
                                                            width: 1.5),
                                                      ),
                                                      contentPadding:
                                                          EdgeInsets.all(15.0),
                                                      errorMaxLines: 2,
                                                    ),
                                                    validator: (value) {
                                                      if (value!.length < 6) {
                                                        return S
                                                            .of(context)
                                                            .validationForMinimumNumber(
                                                                6);
                                                      } else {
                                                        return null;
                                                      }
                                                    },
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ],
                                      ),
                                    ),
                                    Row(
                                      children: [
                                        SizedBox(width: 15.0),
                                        Expanded(
                                          flex: 1,
                                          child: Container(
                                            decoration: BoxDecoration(
                                              color: Color(0xffE1E1E1),
                                              borderRadius:
                                                  BorderRadius.circular(12.0),
                                            ),
                                            child: Material(
                                              borderRadius:
                                                  BorderRadius.circular(32.0),
                                              type: MaterialType.transparency,
                                              shadowColor:
                                                  Colors.white.withOpacity(0.3),
                                              child: InkWell(
                                                onTap: () {
                                                  Navigator.pop(context);
                                                },
                                                child: Container(
                                                  padding: EdgeInsets.symmetric(
                                                      horizontal: 15.0,
                                                      vertical: 15.0),
                                                  decoration: BoxDecoration(
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            32.0),
                                                  ),
                                                  child: Center(
                                                    child: Text(
                                                      "${S.of(context).close}",
                                                      style:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                        color:
                                                            Color(0xff333333),
                                                        fontSize: 16.0,
                                                        fontWeight:
                                                            FontWeight.w600,
                                                      ),
                                                      maxLines: 1,
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 12.0),
                                        Expanded(
                                          flex: 2,
                                          child: Container(
                                            decoration: BoxDecoration(
                                              color: Colors.black,
                                              borderRadius:
                                                  BorderRadius.circular(12.0),
                                            ),
                                            child: Material(
                                              borderRadius:
                                                  BorderRadius.circular(32.0),
                                              type: MaterialType.transparency,
                                              shadowColor:
                                                  Colors.white.withOpacity(0.3),
                                              child: InkWell(
                                                onTap: () async {
                                                  if (numberOfDrivers ==
                                                      S.of(context).unlimited) {
                                                    AddInsuranceModel
                                                        .numberOfDrivers = 8;
                                                  } else {
                                                    AddInsuranceModel
                                                            .numberOfDrivers =
                                                        int.parse(
                                                            numberOfDrivers!);
                                                  }
                                                  AddInsuranceModel.number =
                                                      numberController.text;
                                                  AddInsuranceModel.series =
                                                      seriesController.text;
                                                  if (AddInsuranceModel.kind ==
                                                      '') {
                                                    if (widget.insurance !=
                                                        null) {
                                                      AddInsuranceModel.kind =
                                                          widget
                                                              .insurance!.kind;
                                                    }
                                                  }
                                                  if (AddInsuranceModel
                                                          .dateEnd ==
                                                      '') {
                                                    if (widget.insurance !=
                                                        null) {
                                                      AddInsuranceModel
                                                          .dateEnd = DateFormat(
                                                              'yyyy-MM-dd')
                                                          .format(DateTime
                                                              .parse(widget
                                                                  .insurance!
                                                                  .dateEnd));
                                                    }
                                                  }
                                                  if (AddInsuranceModel
                                                          .datePassed ==
                                                      '') {
                                                    if (widget.insurance !=
                                                        null) {
                                                      AddInsuranceModel
                                                          .datePassed = DateFormat(
                                                              'yyyy-MM-dd')
                                                          .format(DateTime
                                                              .parse(widget
                                                                  .insurance!
                                                                  .datePassed));
                                                    }
                                                  }
                                                  setState(() {
                                                    loading = true;
                                                  });
                                                  if (_key.currentState!
                                                      .validate()) {
                                                    _carsBloc.add(
                                                        EditCarInsurance(
                                                            MyCarPage
                                                                .currentId!));
                                                  } else {
                                                    setState(() {
                                                      loading = false;
                                                    });
                                                  }
                                                },
                                                child: Container(
                                                  padding: EdgeInsets.symmetric(
                                                      horizontal: 6.0,
                                                      vertical: 15.0),
                                                  decoration: BoxDecoration(
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            32.0),
                                                  ),
                                                  child: Padding(
                                                    padding:
                                                        EdgeInsets.symmetric(
                                                            horizontal: 6.0),
                                                    child: Text(
                                                      (widget.insurance != null)
                                                          ? S.of(context).save
                                                          : S.of(context).add,
                                                      style:
                                                          AppStyle.textStyle()
                                                              .copyWith(
                                                                  color: Colors
                                                                      .white,
                                                                  fontWeight:
                                                                      FontWeight
                                                                          .w600,
                                                                  fontSize:
                                                                      16.0),
                                                      textAlign:
                                                          TextAlign.center,
                                                      maxLines: 1,
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 15.0),
                                      ],
                                    ),
                                    SizedBox(height: 30.0),
                                  ],
                                ),
                              );
                            },
                          ),
                        )),
                  ),
                )
              : NoConnectionScreen(
                  onTap: () {
                    Navigator.pushReplacement(
                      context,
                      FadeRoute(
                          page: InsurancePage(
                        insurance: widget.insurance,
                      )),
                    );
                  },
                );
        });
  }
}
