import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomWarningCard extends StatelessWidget {
  final String title;
  final String content;
  final EdgeInsetsGeometry? margin;

  const CustomWarningCard({
    Key? key,
    this.title = '',
    this.content = '',
    this.margin,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: margin,
      padding: const EdgeInsets.all(16),
      decoration: BoxDecoration(
        color: AppColors.colorf51a51.withOpacity(0.03),
        border: Border.all(width: 1, color: AppColors.colorf51a51),
        borderRadius: BorderRadius.circular(16),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              Container(
                padding: const EdgeInsets.all(6),
                decoration: BoxDecoration(
                  color: AppColors.colorf51a51,
                  shape: BoxShape.circle,
                ),
                child: SvgPicture.asset(
                  'assets/svg/notifications_on_outlined.svg',
                  width: 22,
                  height: 22,
                ),
              ),
              const SizedBox(width: 8),
              Text(
                title,
                style: AppStyle.textStyle().copyWith(
                  fontWeight: FontWeight.w700,
                  fontSize: 18,
                  color: AppColors.colorf51a51,
                ),
              ),
            ],
          ),
          const SizedBox(height: 12),
          Text(
            content,
            style: AppStyle.textStyle().copyWith(
              fontSize: 15,
              color: AppColors.selectedColor,
            ),
          ),
        ],
      ),
    );
  }
}
