import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomRefreshButton extends StatelessWidget {
  final String text;
  final Function()? onTap;

  const CustomRefreshButton({Key? key, this.text = '', this.onTap})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        width: double.infinity,
        height: 60,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: AppColors.colorcacaca,
          borderRadius: BorderRadius.circular(12),
        ),
        child: Text(
          text,
          style: AppStyle.textStyle().copyWith(
            color: AppColors.color333333,
            fontSize: 16,
            fontWeight: FontWeight.w600,
          ),
        ),
      ),
    );
  }
}
