import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomNextButton extends StatelessWidget {
  final String text;
  final EdgeInsets? margin;
  final Widget? icon;
  final Function()? onTap;

  const CustomNextButton({this.onTap, this.text = '', this.margin, this.icon});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        width: double.infinity,
        margin: margin,
        padding: const EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(16),
        ),
        child: Row(
          children: [
            Container(
              constraints: const BoxConstraints(maxHeight: 32, maxWidth: 32),
              padding: const EdgeInsets.all(8),
              decoration: const BoxDecoration(
                color: Color(0xFFDFDFDF),
                shape: BoxShape.circle,
              ),
              child: icon,
            ),
            const SizedBox(width: 14),
            Expanded(
              child: Text(
                text.toUpperCase(),
                style: AppStyle.textStyle().copyWith(
                  fontSize: 16,
                  color: Color(0xff282828),
                ),
              ),
            ),
            const Icon(Icons.chevron_right_outlined),
          ],
        ),
      ),
    );
  }
}
