import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomInfoText extends StatelessWidget {
  final String text;
  final EdgeInsets? margin;

  const CustomInfoText({Key? key, this.text = "", this.margin})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: margin,
      padding: const EdgeInsets.all(16),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(16),
        border: Border.all(
          width: 1,
          color: AppColors.selectedColor,
        ),
        color: Colors.white,
        // color: AppColors.selectedColor.withOpacity(0.05),
      ),
      child: Text(
        text,
        style: AppStyle.textStyle().copyWith(
          fontSize: 15,
          color: AppColors.selectedColor,
        ),
      ),
    );
  }
}
