import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomDetailsText extends StatelessWidget {
  final String title;
  final String content;
  final bool error;

  const CustomDetailsText({
    Key? key,
    this.title = '',
    this.content = '',
    this.error = false,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title,
          maxLines: 2,
          style: AppStyle.textStyle().copyWith(
            fontWeight: FontWeight.w600,
            color: Color(0xff747474),
          ),
        ),
        const SizedBox(width: 40),
        Flexible(
          child: Text(
            content,
            textAlign: TextAlign.end,
            maxLines: 3,
            style: AppStyle.textStyle().copyWith(
              fontWeight: FontWeight.w500,
              color: !error ? Color(0xff282828) : AppColors.colorf51a51,
            ),
          ),
        ),
      ],
    );
  }
}
