import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomBottomSheet extends StatelessWidget {
  final Function() onTap;
  final String title;
  final Color buttonColor;

  const CustomBottomSheet(
      {Key? key,
      required this.onTap,
      required this.title,
      required this.buttonColor})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      height: 75,
      padding: const EdgeInsets.only(left: 16, right: 16, bottom: 14, top: 10),
      color: Color(0xFFE9E9E9),
      child: GestureDetector(
        onTap: onTap,
        child: Container(
          width: double.infinity,
          height: double.infinity,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: buttonColor,
            borderRadius: BorderRadius.circular(12),
          ),
          child: Text(
            title,
            style: AppStyle.textStyle().copyWith(
              color: Colors.white,
              fontSize: 16,
              fontWeight: FontWeight.w600,
            ),
          ),
        ),
      ),
    );
  }
}
