import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';

class CustomAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String titleText;

  final bool isLeadingNeeded;

  const CustomAppBar({required this.titleText, this.isLeadingNeeded = true});

  @override
  Widget build(BuildContext context) {
    return AppBar(
      brightness: Brightness.light,
      backgroundColor: Colors.transparent,
      toolbarHeight: 60.0,
      automaticallyImplyLeading: isLeadingNeeded,
      leading: !isLeadingNeeded
          ? null
          : Material(
              type: MaterialType.transparency,
              child: InkWell(
                onTap: () => Navigator.pop(context),
                child: Container(
                  margin: const EdgeInsets.all(10.0),
                  alignment: Alignment.center,
                  decoration: const BoxDecoration(
                    color: Color(0xffDFDFDF),
                    shape: BoxShape.circle,
                  ),
                  child: const Icon(
                    Icons.arrow_back_ios_rounded,
                    size: 20.0,
                    color: Colors.black,
                  ),
                ),
              ),
            ),
      title: Text(
        titleText,
        style: AppStyle.textStyle().copyWith(
          color: Colors.black,
          fontWeight: FontWeight.w600,
          fontSize: 17.0,
        ),
      ),
    );
  }

  @override
  Size get preferredSize => Size.fromHeight(kToolbarHeight);
}
