class InspectionModel {
  const InspectionModel({this.response, this.isNew});

  final Response? response;
  final bool? isNew;

  factory InspectionModel.fromJson(Map<String, dynamic> json) =>
      InspectionModel(
        response: json["response"] == null
            ? null
            : Response.fromJson(json["response"]),
        isNew: json["is_new"],
      );
}

class Response {
  const Response({required this.result, this.error});

  final Result result;
  final String? error;

  factory Response.fromJson(Map<String, dynamic> json) => Response(
        result: Result.fromJson(json["result"]),
        error: json["error"],
      );
}

class Result {
  const Result({required this.vehicle, required this.code, this.message});

  final List<Vehicle> vehicle;
  final int code;
  final String? message;

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        vehicle: json["Vehicle"] == "[]" || json["Vehicle"] == "null"
            ? []
            : List<Vehicle>.from(
                json["Vehicle"].map((x) => Vehicle.fromJson(x))),
        code: json["Code"],
        message: json["Message"],
      );
}

class Vehicle {
  const Vehicle({
    this.pVehicleId,
    this.pPlateNumber,
    this.pModel,
    this.pVehicleColor,
    this.pRegistrationDate,
    this.pDivision,
    this.pYear,
    this.pVehicleType,
    this.pKuzov,
    this.pFullWeight,
    this.pEmptyWeight,
    this.pMotor,
    this.pFuelType,
    this.pSeats,
    this.pStands,
    this.pComments,
    this.inspection,
  });

  final int? pVehicleId;
  final String? pPlateNumber;
  final String? pModel;
  final String? pVehicleColor;
  final String? pRegistrationDate;
  final String? pDivision;
  final String? pYear;
  final int? pVehicleType;
  final String? pKuzov;
  final String? pFullWeight;
  final String? pEmptyWeight;
  final String? pMotor;
  final int? pFuelType;
  final String? pSeats;
  final String? pStands;
  final String? pComments;
  final Inspection? inspection;

  factory Vehicle.fromJson(Map<String, dynamic> json) => Vehicle(
        pVehicleId: json["pVehicleId"],
        pPlateNumber: json["pPlateNumber"],
        pModel: json["pModel"],
        pVehicleColor: json["pVehicleColor"],
        pRegistrationDate: json["pRegistrationDate"],
        pDivision: json["pDivision"],
        pYear: json["pYear"],
        pVehicleType: json["pVehicleType"],
        pKuzov: json["pKuzov"],
        pFullWeight: json["pFullWeight"],
        pEmptyWeight: json["pEmptyWeight"],
        pMotor: json["pMotor"],
        pFuelType: json["pFuelType"],
        pSeats: json["pSeats"],
        pStands: json["pStands"],
        pComments: json["pComments"],
        inspection: json["Inspection"] == null
            ? null
            : Inspection.fromJson(json["Inspection"]),
      );
}

class Inspection {
  const Inspection({
    this.resultInpsection,
    this.dateInpsection,
    this.dateNextInpsection,
    this.specialMarks,
    this.authority,
  });

  final String? resultInpsection;
  final String? dateInpsection;
  final String? dateNextInpsection;
  final String? specialMarks;
  final String? authority;

  factory Inspection.fromJson(Map<String, dynamic> json) => Inspection(
        resultInpsection: json["resultInpsection"],
        dateInpsection: json["dateInpsection"],
        dateNextInpsection: json["dateNextInpsection"],
        specialMarks: json["specialMarks"],
        authority: json["authority"],
      );
}
