import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:modal_progress_hud_nsn/modal_progress_hud_nsn.dart';
import 'package:road24_mobile/data/repository/CarsRepository.dart';
import 'package:road24_mobile/data/response/CarsResponse.dart';
import 'package:road24_mobile/model/blocs/mycar/cars_bloc.dart';
import 'package:road24_mobile/model/models/AddCarModel.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/my_app.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/home/dash_board.dart';
import 'package:road24_mobile/view/mycar/my_car_page.dart';
import 'package:road24_mobile/view/widgets/custom_bottom_tabbar.dart';
import 'package:road24_mobile/view/widgets/fade_route.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import 'package:road24_mobile/view/widgets/success_page.dart';
import 'package:road24_mobile/view/widgets/text_field_custom_formatter.dart';
import 'package:road24_mobile/utils/extensions.dart';
import 'package:intl/intl.dart';

import 'inspection/widgets/custom_appbar.dart';

class ConfidentPage extends StatefulWidget {
  final Confidant? confidant;
  static List<String>? types;

  const ConfidentPage({Key? key, this.confidant}) : super(key: key);

  @override
  _ConfidentPageState createState() => _ConfidentPageState();
}

class _ConfidentPageState extends State<ConfidentPage> {
  bool loading = false;
  CarsBloc _carsBloc = CarsBloc(repository: CarsRepository());
  GlobalKey<FormState> _key = GlobalKey();
  String? typesValue;
  List<String> typesToSend = ['one_time', 'special', 'general'];
  late TextEditingController datePassedController;
  late TextEditingController dateEndController;
  late TextEditingController name;
  late TextEditingController series;
  late TextEditingController number;

  @override
  void initState() {
    if (widget.confidant != null) {
      var confidant = widget.confidant!;
      series = TextEditingController(text: confidant.series);
      number = TextEditingController(text: confidant.number);
      name = TextEditingController(text: confidant.issuedTo);
      datePassedController = TextEditingController(
          text: DateTime.parse(confidant.datePassed).dateToStr());

      dateEndController = TextEditingController(
          text: DateTime.parse(confidant.dateEnd).dateToStr());

      print('-------');
      print(dateEndController.text);
      AddConfidantModel.kind = confidant.kind;
      AddConfidantModel.confidantSeries = series.text;
      AddConfidantModel.confidantNumber = number.text;
      AddConfidantModel.issuedTo = name.text;
      AddConfidantModel.datePassed =
          DateFormat('yyyy-MM-dd').format(DateTime.parse(confidant.datePassed));
      AddConfidantModel.dateEnd =
          DateFormat('yyyy-MM-dd').format(DateTime.parse(confidant.dateEnd));
    } else {
      series = TextEditingController();
      number = TextEditingController();
      name = TextEditingController();
      datePassedController = TextEditingController();
      dateEndController = TextEditingController();
    }
    super.initState();
  }

  @override
  void dispose() {
    _carsBloc.close();
    AddConfidantModel.kind = '';
    AddConfidantModel.confidantSeries = '';
    AddConfidantModel.confidantNumber = '';
    AddConfidantModel.issuedTo = '';
    AddConfidantModel.datePassed = '';
    AddConfidantModel.dateEnd = '';
    datePassedController.dispose();
    dateEndController.dispose();
    series.dispose();
    number.dispose();
    name.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    if (ConfidentPage.types == null) {
      ConfidentPage.types = [
        S.of(context).one_time,
        S.of(context).special,
        S.of(context).general
      ];
    }
    if (typesValue == null) {
      if (widget.confidant != null) {
        if (widget.confidant!.kind != null) {
          typesValue =
              ConfidentPage.types![typesToSend.indexOf(widget.confidant!.kind)];
        }
      } else if (widget.confidant == null) {
        typesValue = ConfidentPage.types![0];
      }
      AddConfidantModel.kind =
          typesToSend[ConfidentPage.types!.indexOf(typesValue!)];
    }
    return ValueListenableBuilder(
        valueListenable: MyApp.hasInternet,
        builder: (context, bool hasInternet, _) {
          return (hasInternet)
              ? ModalProgressHUD(
                  inAsyncCall: loading,
                  color: AppColors.unSelectedColor,
                  progressIndicator: CircularProgressIndicator(
                    strokeWidth: 3.0,
                    valueColor: AlwaysStoppedAnimation<Color>(
                      AppColors.unSelectedColor,
                    ),
                  ),
                  child: GestureDetector(
                    onTap: () {
                      FocusScope.of(context).requestFocus(new FocusNode());
                    },
                    child: Scaffold(
                      appBar: CustomAppBar(titleText: S.of(context).confidant),
                      body: BlocListener(
                        listener: (context, state) {
                          if (state is EditCarSuccessState) {
                            setState(() {
                              loading = false;
                            });
                            Navigator.pushReplacement(
                              context,
                              CupertinoPageRoute(
                                builder: (context) => SuccessPage(
                                  text: S.of(context).success,
                                  subText: S.of(context).edit_car_success_ins,
                                  onTap: () {
                                    DashBoard.activeTab.value =
                                        CustomBottomTabBar.indexMap['MyAvto']!;
                                    Navigator.pop(context);
                                    MyCarPage.needToRefresh.value = true;
                                  },
                                ),
                              ),
                            );
                          }
                          if (state is CarsLoadingError) {
                            setState(() {
                              loading = false;
                            });
                          }
                        },
                        bloc: _carsBloc,
                        child: BlocBuilder(
                          bloc: _carsBloc,
                          builder: (context, state) {
                            return Form(
                              key: _key,
                              child: Column(
                                children: [
                                  Expanded(
                                    child: ListView(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 15.0),
                                      children: [
                                        const SizedBox(height: 10.0),
                                        Text(
                                          "${S.of(context).validity}",
                                          style: AppStyle.textStyle().copyWith(
                                              color: Color(0xFF959595),
                                              fontSize: 15.0,
                                              fontWeight: FontWeight.normal),
                                        ),
                                        Row(
                                          children: [
                                            Expanded(
                                              flex: 1,
                                              child: Container(
                                                // height: 50.0,
                                                margin:
                                                    const EdgeInsets.symmetric(
                                                        vertical: 3.0),
                                                child: InkWell(
                                                  onTap: () {
                                                    showDatePicker(
                                                      context: context,
                                                      initialDate:
                                                          DateTime.now(),
                                                      firstDate: DateTime(
                                                          DateTime.now().year -
                                                              20),
                                                      lastDate: DateTime.now(),
                                                      locale: Locale(
                                                          (Config.language !=
                                                                  'oz')
                                                              ? Config.language
                                                              : 'uz'),
                                                    ).then(
                                                      (value) => {
                                                        this.setState(() {
                                                          try {
                                                            AddConfidantModel
                                                                    .datePassed =
                                                                DateFormat(
                                                                        'yyyy-MM-dd')
                                                                    .format(
                                                                        value!);
                                                            print(value);
                                                            datePassedController
                                                                    .text =
                                                                value
                                                                    .dateToStr();
                                                          } catch (_) {}
                                                        }),
                                                      },
                                                    );
                                                  },
                                                  child: IgnorePointer(
                                                    ignoring: true,
                                                    child: passedField(context),
                                                  ),
                                                ),
                                              ),
                                            ),
                                            const SizedBox(width: 15.0),
                                            Expanded(
                                              flex: 1,
                                              child: Container(
                                                // height: 50.0,
                                                margin:
                                                    const EdgeInsets.symmetric(
                                                        vertical: 3.0),
                                                child: InkWell(
                                                  onTap: () {
                                                    showDatePicker(
                                                      context: context,
                                                      initialDate:
                                                          DateTime.now(),
                                                      firstDate: DateTime.now(),
                                                      lastDate: DateTime(
                                                          DateTime.now().year +
                                                              10),
                                                      locale: Locale(
                                                          (Config.language !=
                                                                  'oz')
                                                              ? Config.language
                                                              : 'uz'),
                                                    ).then(
                                                      (value) => {
                                                        this.setState(() {
                                                          try {
                                                            AddConfidantModel
                                                                    .dateEnd =
                                                                DateFormat(
                                                                        'yyyy-MM-dd')
                                                                    .format(
                                                                        value!);
                                                            print(value);
                                                            dateEndController
                                                                    .text =
                                                                value
                                                                    .dateToStr();
                                                          } catch (_) {}
                                                        }),
                                                      },
                                                    );
                                                  },
                                                  child: IgnorePointer(
                                                    ignoring: true,
                                                    child:
                                                        dateEndField(context),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                        Text(
                                          "${S.of(context).confidant_type}",
                                          style: AppStyle.textStyle().copyWith(
                                              color: Color(0xFF959595),
                                              fontSize: 15.0,
                                              fontWeight: FontWeight.normal),
                                        ),
                                        Container(
                                          height: 50.0,
                                          padding: const EdgeInsets.symmetric(
                                              horizontal: 15.0),
                                          margin: const EdgeInsets.symmetric(
                                              vertical: 6.0),
                                          decoration: BoxDecoration(
                                            borderRadius:
                                                BorderRadius.circular(12.0),
                                            color: Color(0xffEFEFEF),
                                            border: Border.all(
                                                color: Color(0xFFE0E0E0),
                                                width: 1.0),
                                          ),
                                          child: Center(
                                            child: DropdownButton(
                                              isExpanded: true,
                                              underline: SizedBox(),
                                              items: ConfidentPage.types!
                                                  .map((String value) {
                                                return DropdownMenuItem<String>(
                                                  value: value,
                                                  child: Text(
                                                    value,
                                                    style: AppStyle.textStyle()
                                                        .copyWith(
                                                      color: AppColors
                                                          .unSelectedColor,
                                                      fontSize: 17.0,
                                                      fontWeight:
                                                          FontWeight.normal,
                                                    ),
                                                  ),
                                                );
                                              }).toList(),
                                              onChanged: (String? value) {
                                                setState(() {
                                                  typesValue = value;
                                                  AddConfidantModel.kind =
                                                      typesToSend[ConfidentPage
                                                          .types!
                                                          .indexOf(
                                                              typesValue!)];
                                                });
                                              },
                                              hint: Text(
                                                typesValue ??
                                                    '${S.of(context).confidant_type}',
                                                style: TextStyle(
                                                  fontSize: 17.0,
                                                  fontWeight: FontWeight.w300,
                                                ),
                                              ),
                                              // style: TextStyle(
                                              //   color: Colors.red
                                              // ),
                                            ),
                                          ),
                                        ),
                                        const SizedBox(height: 10.0),
                                        Text(
                                          "${S.of(context).issued_to}",
                                          style: AppStyle.textStyle().copyWith(
                                            color: Color(0xFF959595),
                                            fontSize: 15.0,
                                            fontWeight: FontWeight.normal,
                                          ),
                                          overflow: TextOverflow.ellipsis,
                                          maxLines: 1,
                                        ),
                                        Container(
                                          // height: 50.0,
                                          margin: const EdgeInsets.symmetric(
                                              vertical: 3.0),
                                          child: TextFormField(
                                            cursorColor:
                                                AppColors.selectedColor,
                                            controller: name,
                                            inputFormatters: [
                                              CustomTextInputFormatter(30),
                                            ],
                                            keyboardType: TextInputType.text,
                                            textCapitalization:
                                                TextCapitalization.words,
                                            decoration: InputDecoration(
                                              hintText: S
                                                  .of(context)
                                                  .name_placeholder,
                                              hintStyle:
                                                  AppStyle.textStyle().copyWith(
                                                color:
                                                    AppColors.unSelectedColor,
                                                fontSize: 17.0,
                                                fontWeight: FontWeight.normal,
                                              ),
                                              border: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(12.0),
                                                borderSide: BorderSide(
                                                    color: Colors.transparent),
                                              ),
                                              enabledBorder: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(12.0),
                                                borderSide: BorderSide(
                                                    color: Color(0xFFE0E0E0),
                                                    width: 1.0),
                                              ),
                                              fillColor: Color(0xffEFEFEF),
                                              filled: true,
                                              focusedBorder: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(12.0),
                                                borderSide: BorderSide(
                                                    color: Colors.black,
                                                    width: 1.5),
                                              ),
                                              contentPadding:
                                                  EdgeInsets.all(15.0),
                                              errorMaxLines: 2,
                                            ),
                                            validator: (value) {
                                              if (value!.isEmpty) {
                                                return S
                                                    .of(context)
                                                    .validationForEmpty;
                                              } else {
                                                return null;
                                              }
                                            },
                                          ),
                                        ),
                                        Row(
                                          children: [
                                            Expanded(
                                              flex: 1,
                                              child: Text(
                                                "${S.of(context).series}",
                                                style: AppStyle.textStyle()
                                                    .copyWith(
                                                        color:
                                                            Color(0xFF959595),
                                                        fontSize: 15.0,
                                                        fontWeight:
                                                            FontWeight.normal),
                                              ),
                                            ),
                                            SizedBox(width: 15.0),
                                            Expanded(
                                              flex: 2,
                                              child: Text(
                                                "${S.of(context).number}",
                                                style: AppStyle.textStyle()
                                                    .copyWith(
                                                        color:
                                                            Color(0xFF959595),
                                                        fontSize: 15.0,
                                                        fontWeight:
                                                            FontWeight.normal),
                                              ),
                                            ),
                                          ],
                                        ),
                                        Row(
                                          children: [
                                            Expanded(
                                              flex: 1,
                                              child: Container(
                                                // height: 50.0,
                                                margin: EdgeInsets.symmetric(
                                                    vertical: 3.0),
                                                child: TextFormField(
                                                  cursorColor:
                                                      AppColors.selectedColor,
                                                  controller: series,
                                                  inputFormatters: [
                                                    CustomTextInputFormatter(3),
                                                    FilteringTextInputFormatter
                                                        .allow(
                                                            RegExp("[a-zA-Z]")),
                                                    UpperCaseTextFormatter(),
                                                  ],
                                                  keyboardType:
                                                      TextInputType.text,
                                                  decoration: InputDecoration(
                                                    hintText: 'AAA',
                                                    hintStyle:
                                                        AppStyle.textStyle()
                                                            .copyWith(
                                                      color: AppColors
                                                          .unSelectedColor,
                                                      fontSize: 17.0,
                                                      fontWeight:
                                                          FontWeight.normal,
                                                    ),
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              12.0),
                                                      borderSide: BorderSide(
                                                          color: Colors
                                                              .transparent),
                                                    ),
                                                    enabledBorder:
                                                        OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              12.0),
                                                      borderSide: BorderSide(
                                                          color:
                                                              Color(0xFFE0E0E0),
                                                          width: 1.0),
                                                    ),
                                                    fillColor:
                                                        Color(0xffEFEFEF),
                                                    filled: true,
                                                    focusedBorder:
                                                        OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              12.0),
                                                      borderSide: BorderSide(
                                                          color: Colors.black,
                                                          width: 1.5),
                                                    ),
                                                    contentPadding:
                                                        EdgeInsets.all(15.0),
                                                    errorMaxLines: 2,
                                                  ),
                                                  validator: (value) {
                                                    if (value!.length < 2) {
                                                      return S
                                                          .of(context)
                                                          .validationForEmpty;
                                                    } else {
                                                      return null;
                                                    }
                                                  },
                                                ),
                                              ),
                                            ),
                                            const SizedBox(width: 15.0),
                                            Expanded(
                                              flex: 2,
                                              child: Padding(
                                                // height: 50.0,
                                                padding:
                                                    const EdgeInsets.symmetric(
                                                        vertical: 3.0),
                                                child: TextFormField(
                                                  cursorColor:
                                                      AppColors.selectedColor,
                                                  controller: number,
                                                  inputFormatters: [
                                                    CustomTextInputFormatter(8),
                                                    FilteringTextInputFormatter
                                                        .allow(RegExp("[0-9]")),
                                                  ],
                                                  keyboardType:
                                                      TextInputType.number,
                                                  decoration: InputDecoration(
                                                    hintText: '01234567',
                                                    hintStyle:
                                                        AppStyle.textStyle()
                                                            .copyWith(
                                                      color: AppColors
                                                          .unSelectedColor,
                                                      fontSize: 17.0,
                                                      fontWeight:
                                                          FontWeight.normal,
                                                    ),
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              12.0),
                                                      borderSide: BorderSide(
                                                          color: Colors
                                                              .transparent),
                                                    ),
                                                    enabledBorder:
                                                        OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              12.0),
                                                      borderSide: BorderSide(
                                                          color:
                                                              Color(0xFFE0E0E0),
                                                          width: 1.0),
                                                    ),
                                                    fillColor:
                                                        Color(0xffEFEFEF),
                                                    filled: true,
                                                    focusedBorder:
                                                        OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              12.0),
                                                      borderSide: BorderSide(
                                                          color: Colors.black,
                                                          width: 1.5),
                                                    ),
                                                    contentPadding:
                                                        EdgeInsets.all(15.0),
                                                    errorMaxLines: 2,
                                                  ),
                                                  validator: (value) {
                                                    if (value!.length < 6) {
                                                      return S
                                                          .of(context)
                                                          .validationForMinimumNumber(
                                                              6);
                                                    } else {
                                                      return null;
                                                    }
                                                  },
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  ),
                                  Row(
                                    children: [
                                      const SizedBox(width: 15.0),
                                      Expanded(
                                        flex: 1,
                                        child: Container(
                                          decoration: BoxDecoration(
                                            color: Color(0xffE1E1E1),
                                            borderRadius:
                                                BorderRadius.circular(12.0),
                                          ),
                                          child: Material(
                                            borderRadius:
                                                BorderRadius.circular(32.0),
                                            type: MaterialType.transparency,
                                            shadowColor:
                                                Colors.white.withOpacity(0.3),
                                            child: InkWell(
                                              onTap: () {
                                                Navigator.pop(context);
                                              },
                                              child: Container(
                                                padding:
                                                    const EdgeInsets.symmetric(
                                                        horizontal: 15.0,
                                                        vertical: 15.0),
                                                decoration: BoxDecoration(
                                                  borderRadius:
                                                      BorderRadius.circular(
                                                          32.0),
                                                ),
                                                child: Center(
                                                  child: Text(
                                                    "${S.of(context).close}",
                                                    style: AppStyle.textStyle()
                                                        .copyWith(
                                                      color: Color(0xff333333),
                                                      fontSize: 16.0,
                                                      fontWeight:
                                                          FontWeight.w600,
                                                    ),
                                                    maxLines: 1,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                      const SizedBox(width: 12.0),
                                      Expanded(
                                        flex: 2,
                                        child: Container(
                                          decoration: BoxDecoration(
                                            color: Colors.black,
                                            borderRadius:
                                                BorderRadius.circular(12.0),
                                          ),
                                          child: Material(
                                            borderRadius:
                                                BorderRadius.circular(32.0),
                                            type: MaterialType.transparency,
                                            shadowColor:
                                                Colors.white.withOpacity(0.3),
                                            child: InkWell(
                                              onTap: () async {
                                                AddConfidantModel.issuedTo =
                                                    name.text;
                                                AddConfidantModel
                                                        .confidantNumber =
                                                    number.text;
                                                AddConfidantModel
                                                        .confidantSeries =
                                                    series.text;
                                                if (AddConfidantModel.kind ==
                                                    '') {
                                                  if (widget.confidant !=
                                                      null) {
                                                    AddConfidantModel.kind =
                                                        widget.confidant!.kind;
                                                  }
                                                }
                                                if (AddConfidantModel.dateEnd ==
                                                    '') {
                                                  if (widget.confidant !=
                                                      null) {
                                                    AddConfidantModel.dateEnd =
                                                        DateFormat('yyyy-MM-dd')
                                                            .format(DateTime
                                                                .parse(widget
                                                                    .confidant!
                                                                    .dateEnd));
                                                  }
                                                }
                                                if (AddConfidantModel
                                                        .datePassed ==
                                                    '') {
                                                  if (widget.confidant !=
                                                      null) {
                                                    AddConfidantModel
                                                        .datePassed = DateFormat(
                                                            'yyyy-MM-dd')
                                                        .format(DateTime.parse(
                                                            widget.confidant!
                                                                .datePassed));
                                                  }
                                                }
                                                setState(() {
                                                  loading = true;
                                                });
                                                if (_key.currentState!
                                                    .validate()) {
                                                  _carsBloc.add(
                                                      EditCarConfidant(MyCarPage
                                                          .currentId!));
                                                } else {
                                                  setState(() {
                                                    loading = false;
                                                  });
                                                }
                                              },
                                              child: Container(
                                                padding:
                                                    const EdgeInsets.symmetric(
                                                        horizontal: 6.0,
                                                        vertical: 15.0),
                                                decoration: BoxDecoration(
                                                  borderRadius:
                                                      BorderRadius.circular(
                                                          32.0),
                                                ),
                                                child: Padding(
                                                  padding: const EdgeInsets
                                                          .symmetric(
                                                      horizontal: 6.0),
                                                  child: Text(
                                                    (widget.confidant != null)
                                                        ? S.of(context).save
                                                        : S.of(context).add,
                                                    style: AppStyle.textStyle()
                                                        .copyWith(
                                                            color: Colors.white,
                                                            fontWeight:
                                                                FontWeight.w600,
                                                            fontSize: 16.0),
                                                    textAlign: TextAlign.center,
                                                    maxLines: 1,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                      const SizedBox(width: 15.0),
                                    ],
                                  ),
                                  const SizedBox(height: 30.0),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ),
                  ),
                )
              : NoConnectionScreen(
                  onTap: () {
                    Navigator.pushReplacement(
                      context,
                      FadeRoute(
                        page: ConfidentPage(
                          confidant: widget.confidant,
                        ),
                      ),
                    );
                  },
                );
        });
  }

  TextFormField dateEndField(BuildContext context) {
    return TextFormField(
      cursorColor: AppColors.selectedColor,
      controller: dateEndController,
      keyboardType: TextInputType.text,
      decoration: InputDecoration(
        hintText: 'дд.мм.гг',
        hintStyle: AppStyle.textStyle().copyWith(
          color: AppColors.unSelectedColor,
          fontSize: 17.0,
          fontWeight: FontWeight.normal,
        ),
        border: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.transparent),
        ),
        enabledBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Color(0xFFE0E0E0), width: 1.0),
        ),
        fillColor: Color(0xffEFEFEF),
        filled: true,
        focusedBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.black, width: 1.5),
        ),
        contentPadding: EdgeInsets.all(15.0),
        errorMaxLines: 2,
      ),
      validator: (value) {
        if (value!.isEmpty) {
          return S.of(context).validationForEmpty;
        } else {
          return null;
        }
      },
    );
  }

  TextFormField passedField(BuildContext context) {
    return TextFormField(
      cursorColor: AppColors.selectedColor,
      controller: datePassedController,
      keyboardType: TextInputType.text,
      decoration: InputDecoration(
        hintText: 'дд.мм.гг',
        hintStyle: AppStyle.textStyle().copyWith(
          color: AppColors.unSelectedColor,
          fontSize: 17.0,
          fontWeight: FontWeight.normal,
        ),
        border: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.transparent),
        ),
        enabledBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Color(0xFFE0E0E0), width: 1.0),
        ),
        fillColor: Color(0xffEFEFEF),
        filled: true,
        focusedBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(12.0),
          borderSide: BorderSide(color: Colors.black, width: 1.5),
        ),
        contentPadding: EdgeInsets.all(15.0),
        errorMaxLines: 2,
      ),
      validator: (value) {
        if (value!.isEmpty) {
          return S.of(context).validationForEmpty;
        } else {
          return null;
        }
      },
    );
  }
}
