import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'add_new_car_law_page.dart';

class AddNewCarLicenceDialog extends StatelessWidget {
  const AddNewCarLicenceDialog({Key? key}) : super(key: key);
  static void show(BuildContext context) {
    showDialog(
        context: context, builder: (_) => const AddNewCarLicenceDialog());
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.transparent,
      body: GestureDetector(
        onTap: () => Navigator.pop(context),
        child: Container(
          width: double.infinity,
          height: double.infinity,
          alignment: Alignment.center,
          color: Colors.transparent,
          child: GestureDetector(
            onTap: () {},
            child: Container(
              margin: const EdgeInsets.symmetric(horizontal: 16),
              decoration: BoxDecoration(
                color: Colors.white,
                borderRadius: BorderRadius.circular(12),
              ),
              child: SingleChildScrollView(
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    const SizedBox(height: 14),
                    Row(
                      children: [
                        Spacer(),
                        GestureDetector(
                          onTap: () => Navigator.pop(context),
                          child: SvgPicture.asset(
                            "assets/svg/close.svg",
                            height: 30,
                          ),
                        ),
                        const SizedBox(width: 14),
                      ],
                    ),
                    Text(
                      S.of(context).my_car_certificate,
                      style: AppStyle.textStyle().copyWith(
                        color: Color(0xff282828),
                        fontWeight: FontWeight.w700,
                        fontSize: 17,
                      ),
                    ),
                    const SizedBox(height: 22),
                    Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 34),
                      child: Image.asset("assets/png/driver_licence1.png"),
                    ),
                    SizedBox(height: 22),
                    Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 34),
                      child: Image.asset("assets/png/driver_licence2.png"),
                    ),
                    const SizedBox(height: 18),
                    GestureDetector(
                      onTap: () {
                        Navigator.push(
                          context,
                          CupertinoPageRoute(
                            builder: (_) => AddNewCarLawPage(),
                          ),
                        );
                      },
                      child: Container(
                        margin: const EdgeInsets.symmetric(horizontal: 34),
                        padding: const EdgeInsets.all(12),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                          border: Border.all(
                            width: 1,
                            color: AppColors.selectedColor,
                          ),
                        ),
                        child: Row(
                          children: [
                            Container(
                              padding: const EdgeInsets.all(8),
                              decoration: BoxDecoration(
                                color: AppColors.appPrimaryColor,
                                shape: BoxShape.circle,
                              ),
                              child: SvgPicture.asset(
                                "assets/svg/info.svg",
                                height: 20,
                              ),
                            ),
                            const SizedBox(width: 12),
                            Text(
                              S.of(context).my_car_important_to_know,
                              style: AppStyle.textStyle().copyWith(
                                color: Color(0xff282828),
                                fontSize: 16,
                                fontWeight: FontWeight.w500,
                              ),
                            ),
                            const Spacer(),
                            const Icon(Icons.chevron_right,
                                color: Color(0xFF858585)),
                          ],
                        ),
                      ),
                    ),
                    const SizedBox(height: 12),
                    GestureDetector(
                      onTap: () => Navigator.pop(context),
                      child: Container(
                        width: double.infinity,
                        margin: const EdgeInsets.symmetric(horizontal: 34),
                        padding: const EdgeInsets.symmetric(vertical: 17),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                          color: AppColors.selectedColor,
                          borderRadius: BorderRadius.circular(12),
                        ),
                        child: Text(
                          S.of(context).close,
                          style: AppStyle.textStyle()
                              .copyWith(
                                color: Color(0xff282828),
                                fontWeight: FontWeight.w700,
                                fontSize: 17,
                              )
                              .copyWith(color: Colors.white),
                        ),
                      ),
                    ),
                    const SizedBox(height: 24),
                  ],
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}
